/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.tileentity.TileSanguinaryPedestal;

public class BlockSanguinaryPedestal
extends BlockTile
implements IBlockRarityProvider,
IBlockTank {
    private final int tier;

    public BlockSanguinaryPedestal(AbstractBlock.Properties properties, int tier) {
        super(properties, TileSanguinaryPedestal::new);
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return this.tier == 1 ? Rarity.UNCOMMON : Rarity.COMMON;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)pos, TileSanguinaryPedestal.class).ifPresent(tile -> player.func_146105_b((ITextComponent)new StringTextComponent(String.format("%,d", tile.getTank().getFluidAmount())).func_240702_b_(" / ").func_240702_b_(String.format("%,d", tile.getTank().getCapacity())).func_240702_b_(" mB"), true));
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, PlayerEntity player) {
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world) {
        return false;
    }
}

