/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSpikedPlateConfig;
import org.cyclops.evilcraft.core.config.configurable.BlockPressurePlate;
import org.cyclops.evilcraft.tileentity.TileSanguinaryPedestal;

public class BlockSpikedPlate
extends BlockPressurePlate {
    public BlockSpikedPlate(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos blockPos) {
        return super.func_196260_a(state, world, blockPos) || world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockSanguinaryPedestal;
    }

    protected void func_185507_b(IWorld worldIn, BlockPos color) {
    }

    protected void func_185508_c(IWorld worldIn, BlockPos pos) {
    }

    protected boolean damageEntity(ServerWorld world, Entity entity, BlockPos blockPos) {
        if (!(entity instanceof PlayerEntity) && entity instanceof LivingEntity) {
            float damage = (float)BlockSpikedPlateConfig.damage;
            ((LivingEntity)entity).field_70718_bc = 100;
            if (entity.func_70097_a((DamageSource)ExtendedDamageSource.spikedDamage(world), damage)) {
                TileEntity tile = world.func_175625_s(blockPos.func_177982_a(0, -1, 0));
                if (tile != null && tile instanceof TileSanguinaryPedestal) {
                    int amount = MathHelper.func_76141_d((float)(damage * (float)BlockSpikedPlateConfig.mobMultiplier));
                    ((TileSanguinaryPedestal)tile).getBonusFluidHandler().fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, amount), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        return false;
    }

    protected int func_180669_e(World world, BlockPos blockPos) {
        VoxelShape shape = this.func_220053_a(world.func_180495_p(blockPos), (IBlockReader)world, blockPos, ISelectionContext.func_216377_a());
        List list = world.func_217357_a(LivingEntity.class, shape.func_197752_a().func_72321_a(0.0, 1.0, 1.0).func_186670_a(blockPos));
        int ret = 0;
        if (!world.func_201670_d() && !list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (entity.func_145773_az() || !this.damageEntity((ServerWorld)world, (Entity)entity, blockPos)) continue;
                ret = 15;
            }
        }
        return ret;
    }

    protected int func_176576_e(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)POWERED, (Comparable)Boolean.valueOf(false)) != false ? 15 : 0;
    }

    protected BlockState func_176575_a(BlockState blockState, int meta) {
        return (BlockState)blockState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return true;
    }
}

