/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.evilcraft.core.block.BlockTileGuiTank;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;

public class BlockSpiritFurnace
extends BlockTileGuiTank
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public BlockSpiritFurnace(AbstractBlock.Properties properties) {
        super(properties, TileSpiritFurnace::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!TileSpiritFurnace.canWork(world, blockPos)) {
            return ActionResultType.FAIL;
        }
        return super.func_225533_a_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    private void triggerDetector(IWorld world, BlockPos blockPos, boolean valid) {
        TileSpiritFurnace.getCubeDetector().detect((IWorldReader)world, blockPos, valid ? null : blockPos, true);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        this.triggerDetector((IWorld)world, pos, true);
    }

    public void func_220082_b(BlockState blockStateNew, World world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.func_220082_b(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.func_177230_c() != blockStateOld.func_177230_c() && !((Boolean)blockStateNew.func_177229_b((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((IWorld)world, blockPos, true);
        }
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector(worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((IWorld)world, pos, false);
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.getBlock().func_180652_a(world, pos, explosion);
    }

    public void onDetect(IWorldReader world, BlockPos location, Vector3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)world.func_180495_p(location).func_177229_b((Property)ACTIVE) == false;
            ((World)world).func_180501_a(location, (BlockState)world.func_180495_p(location).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            TileEntity tile = world.func_175625_s(location);
            if (tile != null) {
                ((TileSpiritFurnace)tile).setSize(valid ? size : Vector3i.field_177959_e);
            }
            if (change) {
                TileSpiritFurnace.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }
}

