/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.tileentity.TileSpiritPortal;

public class BlockSpiritPortal
extends BlockTile {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)6.4f, (double)6.4f, (double)6.4f, (double)9.6f, (double)9.6f, (double)9.6f);

    public BlockSpiritPortal(AbstractBlock.Properties properties) {
        super(properties, TileSpiritPortal::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    protected static boolean canReplaceBlock(BlockState blockState, IWorldReader world, BlockPos pos) {
        return blockState != null && (blockState.func_177230_c().isAir(blockState, (IBlockReader)world, pos) || blockState.func_185904_a().func_76222_j());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void palingDeath(LivingDeathEvent event) {
        if (event.getSource() == ExtendedDamageSource.paling) {
            this.tryPlacePortal(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_233580_cy_().func_177982_a(0, 1, 0));
        }
    }

    public boolean tryPlacePortal(World world, BlockPos blockPos) {
        RegionIterator it = new RegionIterator(blockPos, 1, true);
        for (int attempts = 9; it.hasNext() && attempts >= 0; --attempts) {
            BlockPos location = it.next();
            if (!BlockSpiritPortal.canReplaceBlock(world.func_180495_p(location), (IWorldReader)world, blockPos)) continue;
            world.func_180501_a(location, RegistryEntries.BLOCK_SPIRIT_PORTAL.func_176223_P(), 3);
            return true;
        }
        return false;
    }
}

