/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.block.component.ParticleDropBlockComponent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockUndeadLeavesConfig;
import org.cyclops.evilcraft.tileentity.TileBloodStain;

public class BlockUndeadLeaves
extends LeavesBlock {
    private ParticleDropBlockComponent particleDropBlockComponent;

    public BlockUndeadLeaves(AbstractBlock.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.particleDropBlockComponent = new ParticleDropBlockComponent(1.0f, 0.0f, 0.0f);
            this.particleDropBlockComponent.setOffset(0);
            this.particleDropBlockComponent.setChance(50);
        }
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        this.particleDropBlockComponent.randomDisplayTick(stateIn, worldIn, pos, rand);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this);
    }

    protected boolean canFormBloodStains(BlockState state) {
        return BlockUndeadLeavesConfig.maxBloodStainAmount > 0 && (Boolean)state.func_177229_b((Property)field_208495_b) == false && (Integer)state.func_177229_b((Property)field_208494_a) == 2;
    }

    public boolean func_149653_t(BlockState state) {
        return super.func_149653_t(state) || this.canFormBloodStains(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if (this.canFormBloodStains(state)) {
            int attempts = 20;
            BlockPos itPos = pos.func_177972_a(Direction.DOWN);
            while (attempts-- > 0) {
                if (worldIn.func_180495_p(itPos).func_177230_c() instanceof BlockBloodStain || worldIn.func_175623_d(itPos) && RegistryEntries.BLOCK_BLOOD_STAIN.func_196260_a(state, (IWorldReader)worldIn, itPos)) {
                    BlockState blockState = worldIn.func_180495_p(itPos);
                    if (blockState.isAir((IBlockReader)worldIn, pos)) {
                        blockState = RegistryEntries.BLOCK_BLOOD_STAIN.func_176223_P();
                        worldIn.func_175656_a(itPos, blockState);
                    }
                    if (!(blockState.func_177230_c() instanceof BlockBloodStain)) break;
                    TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)itPos, TileBloodStain.class).ifPresent(tile -> tile.addAmount(1 + worldIn.field_73012_v.nextInt(BlockUndeadLeavesConfig.maxBloodStainAmount)));
                    break;
                }
                if (!worldIn.func_175623_d(itPos)) break;
                itPos = itPos.func_177972_a(Direction.DOWN);
            }
        }
    }
}

