/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;

public class ContainerScreenSanguinaryEnvironmentalAccumulator
extends ContainerScreenTileWorking<ContainerSanguinaryEnvironmentalAccumulator, TileSanguinaryEnvironmentalAccumulator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 77;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSanguinaryEnvironmentalAccumulator(ContainerSanguinaryEnvironmentalAccumulator container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setProgress(24, 16, 192, 0, 77, 36);
    }

    @Override
    protected ITextComponent getName() {
        return new TranslationTextComponent("block.evilcraft.sanguinary_environmental_accumulator");
    }

    @Override
    protected void drawAdditionalForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawAdditionalForeground(matrixStack, mouseX, mouseY);
        String prefix = RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.func_149739_a() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslationTextComponent(prefix));
        if (!((ContainerSanguinaryEnvironmentalAccumulator)this.func_212873_a_()).getTileCanWork()) {
            lines.add(new TranslationTextComponent(prefix + ".invalid_locations"));
            for (Vector3i location : ((ContainerSanguinaryEnvironmentalAccumulator)this.func_212873_a_()).getInvalidLocations()) {
                lines.add(new StringTextComponent(String.format("  X=%s Y=%s Z=%s", location.func_177958_n(), location.func_177956_o(), location.func_177952_p())));
            }
        }
        if (lines.size() > 1) {
            this.func_238474_b_(matrixStack, 77 + this.offsetX, 36 + this.offsetY, 192, 18, 24, 16);
            if (this.func_195359_a(77 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
            }
        }
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/sanguinary_environmental_accumulator_gui.png");
    }
}

