/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;

public class ContainerScreenSpiritFurnace
extends ContainerScreenTileWorking<ContainerSpiritFurnace, TileSpiritFurnace> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 102;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSpiritFurnace(ContainerSpiritFurnace container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(24, 16, 192, 0, 102, 36);
    }

    @Override
    protected ITextComponent getName() {
        return new TranslationTextComponent("block.evilcraft.spirit_furnace");
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/spirit_furnace_gui.png");
    }

    private String prettyPrintSize(@Nullable Vector3i size) {
        if (size == null) {
            return "Loading...";
        }
        return size.func_177958_n() + "x" + size.func_177956_o() + "x" + size.func_177952_p();
    }

    @Override
    protected void drawAdditionalForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        String prefix = RegistryEntries.BLOCK_SPIRIT_FURNACE.func_149739_a() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslationTextComponent(prefix));
        if (!((ContainerSpiritFurnace)this.func_212873_a_()).hasEntity()) {
            lines.add(new TranslationTextComponent(prefix + ".no_entity"));
        } else if (!((ContainerSpiritFurnace)this.func_212873_a_()).isSizeValidForEntity()) {
            lines.add(new TranslationTextComponent(prefix + ".content_size", new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.func_212873_a_()).getInnerSize())}));
            lines.add(new TranslationTextComponent(prefix + ".required_size", new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.func_212873_a_()).getEntitySize())}));
        } else if (((ContainerSpiritFurnace)this.func_212873_a_()).isForceHalt()) {
            lines.add(new TranslationTextComponent(prefix + ".force_halt"));
        } else if (((ContainerSpiritFurnace)this.func_212873_a_()).isCaughtError()) {
            lines.add(new TranslationTextComponent(prefix + ".caught_error"));
        }
        if (lines.size() > 1) {
            this.func_238474_b_(matrixStack, 102 + this.offsetX, 36 + this.offsetY, 192, 18, 24, 16);
            if (this.func_195359_a(102 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
            }
        }
    }
}

