/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;
import org.cyclops.evilcraft.tileentity.TileSpiritReanimator;

public class ContainerScreenSpiritReanimator
extends ContainerScreenTileWorking<ContainerSpiritReanimator, TileSpiritReanimator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 10;
    public static final int PROGRESSHEIGHT = 24;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 119;
    public static final int PROGRESSTARGETY = 26;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 24;

    public ContainerScreenSpiritReanimator(ContainerSpiritReanimator container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(10, 24, 192, 0, 119, 26);
    }

    @Override
    protected ITextComponent getName() {
        return new TranslationTextComponent("block.evilcraft.spirit_reanimator");
    }

    public ResourceLocation constructGuiTexture() {
        return new ResourceLocation("evilcraft", "textures/gui/spirit_reanimator_gui.png");
    }

    @Override
    protected void drawAdditionalForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        String prefix = RegistryEntries.BLOCK_SPIRIT_REANIMATOR.func_149739_a() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(new TranslationTextComponent(prefix));
        String entityName = ((ContainerSpiritReanimator)this.func_212873_a_()).getEntityName();
        if (entityName == null) {
            lines.add(new TranslationTextComponent(prefix + ".no_entity"));
        } else if (entityName.isEmpty()) {
            lines.add(new TranslationTextComponent(prefix + ".invalid_entity"));
        } else {
            ItemStack outputStack = ((ContainerSpiritReanimator)this.func_212873_a_()).getContainerInventory().func_70301_a(3);
            if (!outputStack.func_190926_b() && outputStack.func_77973_b() instanceof SpawnEggItem && ((SpawnEggItem)outputStack.func_77973_b()).func_208076_b(outputStack.func_77978_p()) != ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName))) {
                lines.add(new TranslationTextComponent(prefix + ".different_egg"));
            }
        }
        if (lines.size() > 1) {
            this.func_238474_b_(matrixStack, 119 + this.offsetX, 26 + this.offsetY, 192, 24, 10, 24);
            if (this.func_195359_a(119 + this.offsetX, 26 + this.offsetY, 10, 24, mouseX, mouseY)) {
                this.drawTooltip(lines, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
            }
        }
    }

    @Override
    protected int getProgressXScaled(int width) {
        return width;
    }

    @Override
    protected int getProgressYScaled(int height) {
        return ((ContainerSpiritReanimator)this.func_212873_a_()).getProgress(0) * 24 / ((ContainerSpiritReanimator)this.func_212873_a_()).getMaxProgress(0);
    }
}

