/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleBlurTargettedData
extends ParticleBlurData {
    public static final IParticleData.IDeserializer<ParticleBlurTargettedData> DESERIALIZER = new IParticleData.IDeserializer<ParticleBlurTargettedData>(){

        public ParticleBlurTargettedData deserialize(ParticleType<ParticleBlurTargettedData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = (float)reader.readDouble();
            reader.expect(' ');
            float green = (float)reader.readDouble();
            reader.expect(' ');
            float blue = (float)reader.readDouble();
            reader.expect(' ');
            float scale = (float)reader.readDouble();
            reader.expect(' ');
            float ageMultiplier = (float)reader.readDouble();
            reader.expect(' ');
            float targetX = (float)reader.readDouble();
            reader.expect(' ');
            float targetY = (float)reader.readDouble();
            reader.expect(' ');
            float targetZ = (float)reader.readDouble();
            return new ParticleBlurTargettedData(red, green, blue, scale, ageMultiplier, targetX, targetY, targetZ);
        }

        public ParticleBlurTargettedData read(ParticleType<ParticleBlurTargettedData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleBlurTargettedData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<ParticleBlurTargettedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleBlurData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleBlurData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleBlurData::getBlue), (App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleBlurData::getScale), (App)Codec.FLOAT.fieldOf("age").forGetter(ParticleBlurData::getAgeMultiplier), (App)Codec.FLOAT.fieldOf("x").forGetter(ParticleBlurTargettedData::getTargetX), (App)Codec.FLOAT.fieldOf("y").forGetter(ParticleBlurTargettedData::getTargetY), (App)Codec.FLOAT.fieldOf("z").forGetter(ParticleBlurTargettedData::getTargetZ)).apply((Applicative)builder, ParticleBlurTargettedData::new));
    private final float targetX;
    private final float targetY;
    private final float targetZ;

    public ParticleBlurTargettedData(float red, float green, float blue, float scale, float ageMultiplier, float targetX, float targetY, float targetZ) {
        super(red, green, blue, scale, ageMultiplier);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    public float getTargetX() {
        return this.targetX;
    }

    public float getTargetY() {
        return this.targetY;
    }

    public float getTargetZ() {
        return this.targetZ;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_BLUR_TARGETTED;
    }

    public void func_197553_a(PacketBuffer buffer) {
        super.func_197553_a(buffer);
        buffer.writeFloat(this.targetX);
        buffer.writeFloat(this.targetY);
        buffer.writeFloat(this.targetZ);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", super.func_197555_a(), Float.valueOf(this.targetX), Float.valueOf(this.targetY), Float.valueOf(this.targetZ));
    }
}

