/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleBubbleExtendedData
implements IParticleData {
    public static final IParticleData.IDeserializer<ParticleBubbleExtendedData> DESERIALIZER = new IParticleData.IDeserializer<ParticleBubbleExtendedData>(){

        public ParticleBubbleExtendedData deserialize(ParticleType<ParticleBubbleExtendedData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float gravity = (float)reader.readDouble();
            return new ParticleBubbleExtendedData(gravity);
        }

        public ParticleBubbleExtendedData read(ParticleType<ParticleBubbleExtendedData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleBubbleExtendedData(buffer.readFloat());
        }
    };
    public static final Codec<ParticleBubbleExtendedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("gravity").forGetter(ParticleBubbleExtendedData::getGravity)).apply((Applicative)builder, ParticleBubbleExtendedData::new));
    private final float gravity;

    public ParticleBubbleExtendedData(float gravity) {
        this.gravity = gravity;
    }

    public float getGravity() {
        return this.gravity;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_BUBBLE_EXTENDED;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.gravity);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.gravity));
    }
}

