/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleColoredSmokeData
implements IParticleData {
    public static final IParticleData.IDeserializer<ParticleColoredSmokeData> DESERIALIZER = new IParticleData.IDeserializer<ParticleColoredSmokeData>(){

        public ParticleColoredSmokeData deserialize(ParticleType<ParticleColoredSmokeData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = (float)reader.readDouble();
            reader.expect(' ');
            float g = (float)reader.readDouble();
            reader.expect(' ');
            float b = (float)reader.readDouble();
            return new ParticleColoredSmokeData(r, g, b);
        }

        public ParticleColoredSmokeData read(ParticleType<ParticleColoredSmokeData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleColoredSmokeData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<ParticleColoredSmokeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleColoredSmokeData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleColoredSmokeData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleColoredSmokeData::getB)).apply((Applicative)builder, ParticleColoredSmokeData::new));
    private final float r;
    private final float g;
    private final float b;

    public ParticleColoredSmokeData(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_COLORED_SMOKE;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }
}

