/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleDarkSmokeData
implements IParticleData {
    public static final IParticleData.IDeserializer<ParticleDarkSmokeData> DESERIALIZER = new IParticleData.IDeserializer<ParticleDarkSmokeData>(){
        public boolean entityDead;

        public ParticleDarkSmokeData deserialize(ParticleType<ParticleDarkSmokeData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            this.entityDead = reader.readBoolean();
            return new ParticleDarkSmokeData(this.entityDead);
        }

        public ParticleDarkSmokeData read(ParticleType<ParticleDarkSmokeData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleDarkSmokeData(buffer.readBoolean());
        }
    };
    public static final Codec<ParticleDarkSmokeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("dead").forGetter(ParticleDarkSmokeData::isEntityDead)).apply((Applicative)builder, ParticleDarkSmokeData::new));
    private final boolean entityDead;

    public ParticleDarkSmokeData(boolean entityDead) {
        this.entityDead = entityDead;
    }

    public boolean isEntityDead() {
        return this.entityDead;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_DARK_SMOKE;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeBoolean(this.entityDead);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), this.entityDead);
    }
}

