/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleDistortData
implements IParticleData {
    public static final IParticleData.IDeserializer<ParticleDistortData> DESERIALIZER = new IParticleData.IDeserializer<ParticleDistortData>(){

        public ParticleDistortData deserialize(ParticleType<ParticleDistortData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = (float)reader.readDouble();
            return new ParticleDistortData(scale);
        }

        public ParticleDistortData read(ParticleType<ParticleDistortData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleDistortData(buffer.readFloat());
        }
    };
    public static final Codec<ParticleDistortData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleDistortData::getScale)).apply((Applicative)builder, ParticleDistortData::new));
    private final float scale;

    public ParticleDistortData(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_DISTORT;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.scale);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.scale));
    }
}

