/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleExplosionExtendedData
implements IParticleData {
    public static final IParticleData.IDeserializer<ParticleExplosionExtendedData> DESERIALIZER = new IParticleData.IDeserializer<ParticleExplosionExtendedData>(){

        public ParticleExplosionExtendedData deserialize(ParticleType<ParticleExplosionExtendedData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = (float)reader.readDouble();
            reader.expect(' ');
            float g = (float)reader.readDouble();
            reader.expect(' ');
            float b = (float)reader.readDouble();
            reader.expect(' ');
            float alpha = (float)reader.readDouble();
            return new ParticleExplosionExtendedData(r, g, b, alpha);
        }

        public ParticleExplosionExtendedData read(ParticleType<ParticleExplosionExtendedData> particleTypeIn, PacketBuffer buffer) {
            return new ParticleExplosionExtendedData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<ParticleExplosionExtendedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleExplosionExtendedData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleExplosionExtendedData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleExplosionExtendedData::getB), (App)Codec.FLOAT.fieldOf("alpha").forGetter(ParticleExplosionExtendedData::getAlpha)).apply((Applicative)builder, ParticleExplosionExtendedData::new));
    private final float r;
    private final float g;
    private final float b;
    private final float alpha;

    public ParticleExplosionExtendedData(float r, float g, float b, float alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public ParticleType<?> func_197554_b() {
        return RegistryEntries.PARTICLE_EXPLOSION_EXTENDED;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.alpha);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.alpha));
    }
}

