/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;

public class RenderVengeanceSpirit
extends EntityRenderer<EntityVengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(EntityRendererManager renderManager, EntityVengeanceSpiritConfig config) {
        super(renderManager);
        this.playerRenderer = new RenderPlayerSpirit(renderManager);
    }

    public void render(EntityVengeanceSpirit spirit, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        EntityRenderer render;
        super.func_225623_a_((Entity)spirit, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        MobEntity innerEntity = spirit.getInnerEntity();
        if (innerEntity != null && spirit.isVisible() && (render = (EntityRenderer)this.field_76990_c.field_78729_o.get(innerEntity.func_200600_R())) != null && !spirit.isSwarm()) {
            IRenderTypeBuffer bufferSub = renderType -> {
                float uv = spirit.isFrozen() ? ((float)spirit.field_70173_aa + partialTicks) * 0.01f : 1.0f;
                renderType = RenderType.func_228636_a_((ResourceLocation)(spirit.func_70684_aJ() ? this.playerRenderer : render).func_110775_a((Entity)innerEntity), (float)uv, (float)uv);
                return bufferIn.getBuffer(renderType);
            };
            try {
                if (spirit.func_70684_aJ()) {
                    GameProfile gameProfile = new GameProfile(spirit.getPlayerUUID(), spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
                    Minecraft minecraft = Minecraft.func_71410_x();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                        if (property == null) {
                            GameProfile newGameProfile = Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(gameProfile, true);
                            this.checkedProfiles.put(gameProfile, newGameProfile);
                        }
                    } else {
                        Map map = minecraft.func_152342_ad().func_152788_a(this.checkedProfiles.get(gameProfile));
                        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        }
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    this.playerRenderer.func_225623_a_(innerEntity, entityYaw, partialTicks, matrixStackIn, bufferSub, packedLightIn);
                } else {
                    matrixStackIn.func_227860_a_();
                    render.func_225623_a_((Entity)innerEntity, entityYaw, 0.0f, matrixStackIn, bufferSub, packedLightIn);
                    matrixStackIn.func_227865_b_();
                }
            }
            catch (Exception e) {
                spirit.setSwarm(true);
                spirit.setPlayerId("");
            }
        }
    }

    public ResourceLocation getEntityTexture(EntityVengeanceSpirit entity) {
        return null;
    }

    public static class RenderPlayerSpirit
    extends BipedRenderer<MobEntity, PlayerModel<MobEntity>> {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(EntityRendererManager renderManager) {
            super(renderManager, (BipedModel)new PlayerModel(0.0f, false), 0.5f);
            this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
            this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
            this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
            this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        }

        public ResourceLocation func_110775_a(MobEntity entity) {
            return this.playerTexture;
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }
    }
}

