/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;

public class ModelBoxOfEternalClosureBaked
extends DelegatingDynamicItemAndBlockModel {
    protected static final ItemCameraTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.GUI, (Object)new ItemTransformVec3f(new Vector3f(30.0f, 135.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f))));
    public static IBakedModel boxModel;
    public static IBakedModel boxLidModel;
    public static IBakedModel boxLidRotatedModel;
    private final boolean isOpen;

    public ModelBoxOfEternalClosureBaked() {
        this.isOpen = false;
    }

    public ModelBoxOfEternalClosureBaked(boolean isOpen, ItemStack itemStack, World world, LivingEntity entity) {
        super(itemStack, world, entity);
        this.isOpen = isOpen;
    }

    public List<BakedQuad> getGeneralQuads() {
        if (!this.isItemStack()) {
            return Collections.emptyList();
        }
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(boxModel.func_200117_a(this.blockState, this.facing, this.rand));
        if (this.isOpen) {
            quads.addAll(boxLidRotatedModel.func_200117_a(this.blockState, this.facing, this.rand));
        } else {
            quads.addAll(boxLidModel.func_200117_a(this.blockState, this.facing, this.rand));
        }
        return quads;
    }

    public IBakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        return null;
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        return new ModelBoxOfEternalClosureBaked(BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(itemStack) == null, itemStack, world, entity);
    }

    public TextureAtlasSprite func_177554_e() {
        return boxModel.func_177554_e();
    }

    public boolean func_230044_c_() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return TRANSFORMS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelBoxOfEternalClosureBaked)) {
            return false;
        }
        ModelBoxOfEternalClosureBaked other = (ModelBoxOfEternalClosureBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isOpen() == other.isOpen();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelBoxOfEternalClosureBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpen() ? 79 : 97);
        return result;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return "ModelBoxOfEternalClosureBaked(isOpen=" + this.isOpen() + ")";
    }
}

