/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.client.model.DelegatingChildDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class ModelDarkTankBaked
extends DelegatingChildDynamicItemAndBlockModel {
    private final int capacity;
    private final FluidStack fluidStack;

    public ModelDarkTankBaked(IBakedModel baseModel) {
        super(baseModel);
        this.capacity = 0;
        this.fluidStack = null;
    }

    public ModelDarkTankBaked(IBakedModel baseModel, int capacity, FluidStack fluidStack, BlockState blockState, Direction facing, Random rand, IModelData modelData) {
        super(baseModel, blockState, facing, rand, modelData);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public ModelDarkTankBaked(IBakedModel baseModel, int capacity, FluidStack fluidStack, ItemStack itemStack, World world, LivingEntity entity) {
        super(baseModel, itemStack, world, entity);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public List<BakedQuad> getGeneralQuads() {
        ArrayList combinedList = Lists.newArrayList();
        if (this.fluidStack != null && (BlockDarkTankConfig.staticBlockRendering || this.isItemStack())) {
            boolean flowing = this.isItemStack() && RegistryEntries.BLOCK_DARK_TANK.isActivated(this.itemStack, this.world);
            combinedList.addAll(this.getFluidQuads(this.fluidStack, this.capacity, flowing));
        }
        combinedList.addAll(this.baseModel.func_200117_a(this.blockState, this.getRenderingSide(), this.rand));
        return combinedList;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileDarkTank.class).map(tile -> {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            builder.withInitial(BlockDarkTank.TANK_FLUID, (Object)tile.getTank().getFluid());
            builder.withInitial(BlockDarkTank.TANK_CAPACITY, (Object)tile.getTank().getCapacity());
            return builder.build();
        }).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public IBakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        int capacity = (Integer)ModelHelpers.getSafeProperty((IModelData)modelData, BlockDarkTank.TANK_CAPACITY, (Object)0);
        FluidStack fluidStack = (FluidStack)ModelHelpers.getSafeProperty((IModelData)modelData, BlockDarkTank.TANK_FLUID, (Object)FluidStack.EMPTY);
        return new ModelDarkTankBaked(this.baseModel, capacity, fluidStack, state, side, rand, modelData);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
        if (!itemStack.func_190926_b() && fluidHandler != null) {
            int capacity = fluidHandler.getCapacity();
            FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
            return new ModelDarkTankBaked(this.baseModel, capacity, fluidStack, itemStack, world, entity);
        }
        return new ModelDarkTankBaked(this.baseModel, 0, null, itemStack, world, entity);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, boolean flowing, Direction side) {
        return (TextureAtlasSprite)RenderHelpers.TEXTURE_GETTER.apply((Object)(flowing && side != Direction.UP && side != Direction.DOWN ? fluid.getFluid().getAttributes().getFlowingTexture(fluid) : fluid.getFluid().getAttributes().getStillTexture(fluid)));
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity, boolean flowing) {
        float height = Math.min(0.99f, (float)fluidStack.getAmount() / (float)capacity) / 1.01f;
        ArrayList quads = Lists.newArrayList();
        block8: for (Direction side : Direction.values()) {
            TextureAtlasSprite texture = ModelDarkTankBaked.getFluidIcon(fluidStack, flowing, side);
            int color = RenderHelpers.getFluidBakedQuadColor((FluidStack)fluidStack);
            if (side == Direction.UP) {
                ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)height, (TextureAtlasSprite)texture, (Direction)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            if (side == Direction.DOWN) {
                ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)0.95f, (TextureAtlasSprite)texture, (Direction)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            float width = 0.87f;
            float x1 = 0.13f;
            float x2 = width;
            float z1 = 0.01f;
            float z2 = height;
            if (side == Direction.EAST || side == Direction.SOUTH) {
                z1 = 0.99f - height;
                z2 = 0.99f;
            }
            if (side == Direction.EAST || side == Direction.WEST) {
                float tmp1 = x1;
                float tmp2 = x2;
                x1 = z1;
                x2 = z2;
                z1 = tmp1;
                z2 = tmp2;
            }
            switch (side) {
                case DOWN: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}});
                    continue block8;
                }
                case UP: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}});
                    continue block8;
                }
                case NORTH: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x2, (float)x1, (float)z2, (float)z1, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, height}, {0.0f, height}, {0.0f, 0.0f}});
                    continue block8;
                }
                case SOUTH: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, 0.0f}, {1.0f, height}, {0.0f, height}, {0.0f, 0.0f}});
                    continue block8;
                }
                case WEST: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)0.87f, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{1.0f, height}, {0.0f, height}, {0.0f, 0.0f}, {1.0f, 0.0f}});
                    continue block8;
                }
                case EAST: {
                    ModelDarkTankBaked.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)width, (TextureAtlasSprite)texture, (Direction)side, (int)0, (boolean)true, (int)color, (float[][])new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, height}, {0.0f, height}});
                }
            }
        }
        return quads;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public boolean func_230044_c_() {
        return true;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }
}

