/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.core.client.model.ModelConfigurationRetextured;
import org.cyclops.evilcraft.tileentity.TileDisplayStand;

public class ModelDisplayStandBaked
extends DynamicItemAndBlockModel {
    private static final Map<Direction, ModelRotation> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)ModelRotation.X270_Y0).put((Object)Direction.SOUTH, (Object)ModelRotation.X90_Y0).put((Object)Direction.WEST, (Object)ModelRotation.X90_Y90).put((Object)Direction.EAST, (Object)ModelRotation.X270_Y90).put((Object)Direction.UP, (Object)ModelRotation.X180_Y0).put((Object)Direction.DOWN, (Object)ModelRotation.X0_Y0).build();
    private final SingleCache<ResourceLocation, IBakedModel> modelCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ResourceLocation, IBakedModel>(){

        public IBakedModel getNewValue(ResourceLocation textureName) {
            return ModelDisplayStandBaked.bakeModel(new ModelConfigurationRetextured(ModelDisplayStandBaked.this.owner, textureName), ModelDisplayStandBaked.this.blockModel.func_178298_a(), ModelDisplayStandBaked.this.transform, ItemOverrideList.field_188022_a, ModelLoader.defaultTextureGetter(), new ResourceLocation("evilcraft", "dummy"));
        }

        public boolean isKeyEqual(ResourceLocation resourceLocation, ResourceLocation k1) {
            return resourceLocation.equals((Object)k1);
        }
    });
    private final BlockModel blockModel;
    private final IBakedModel untexturedBakedModel;
    private final TextureAtlasSprite texture;
    private final IModelConfiguration owner;
    private final IModelTransform transform;

    public ModelDisplayStandBaked(BlockModel blockModel, IBakedModel untexturedBakedModel, IModelConfiguration owner, IModelTransform transform) {
        super(true, false);
        this.blockModel = blockModel;
        this.untexturedBakedModel = untexturedBakedModel;
        this.owner = owner;
        this.transform = transform;
        this.texture = null;
    }

    public ModelDisplayStandBaked(BlockModel blockModel, IBakedModel untexturedBakedModel, TextureAtlasSprite texture, boolean item, IModelConfiguration owner, IModelTransform transform) {
        super(false, item);
        this.blockModel = blockModel;
        this.untexturedBakedModel = untexturedBakedModel;
        this.texture = texture;
        this.owner = owner;
        this.transform = transform;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    protected IBakedModel handleDisplayStandType(ItemStack displayStandType, boolean item) {
        if (displayStandType != null && !displayStandType.func_190926_b()) {
            BlockState blockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)displayStandType);
            ResourceLocation textureName = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(blockState).func_177554_e().func_195668_m();
            return (IBakedModel)this.modelCache.get((Object)textureName);
        }
        return this.untexturedBakedModel;
    }

    public static IBakedModel bakeModel(IModelConfiguration modelConfiguration, List<BlockPart> blockParts, IModelTransform transform, ItemOverrideList overrides, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation modelName) {
        TextureAtlasSprite particle = spriteGetter.apply(modelConfiguration.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(modelConfiguration, overrides).func_177646_a(particle);
        for (BlockPart blockPart : blockParts) {
            for (Direction direction : blockPart.field_178240_c.keySet()) {
                BlockPartFace blockPartFace = (BlockPartFace)blockPart.field_178240_c.get(direction);
                String texture = blockPartFace.field_178242_d;
                if (texture.charAt(0) == '#') {
                    texture = texture.substring(1);
                }
                TextureAtlasSprite sprite = spriteGetter.apply(modelConfiguration.resolveTexture(texture));
                if (blockPartFace.field_178244_b == null) {
                    builder.func_177648_a(BlockModel.makeBakedQuad((BlockPart)blockPart, (BlockPartFace)blockPartFace, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)transform, (ResourceLocation)modelName));
                    continue;
                }
                builder.func_177650_a(Direction.func_229385_a_((Matrix4f)transform.func_225615_b_().func_227988_c_(), (Direction)blockPartFace.field_178244_b), BlockModel.makeBakedQuad((BlockPart)blockPart, (BlockPartFace)blockPartFace, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)transform, (ResourceLocation)modelName));
            }
        }
        return builder.func_177645_b();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileDisplayStand.class).map(tile -> {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            builder.withInitial(BlockDisplayStand.DIRECTION, (Object)tile.getDirection());
            builder.withInitial(BlockDisplayStand.TYPE, (Object)tile.getDisplayStandType());
            return builder.build();
        }).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public IBakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        return this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((IModelData)modelData, BlockDisplayStand.TYPE, (Object)ItemStack.field_190927_a), false);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        return this.handleDisplayStandType(RegistryEntries.BLOCK_DISPLAY_STAND.getDisplayStandType(itemStack), true);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.untexturedBakedModel.func_200117_a(null, null, null).stream().map(quad -> new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quad.func_178210_d(), this.texture, quad.func_239287_f_())).collect(Collectors.toList());
    }

    public boolean func_230044_c_() {
        return true;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((IModelData)data, BlockDisplayStand.TYPE, (Object)ItemStack.field_190927_a), false).func_177554_e();
    }
}

