/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.block.BlockEntangledChalice;
import org.cyclops.evilcraft.block.BlockEntangledChaliceConfig;
import org.cyclops.evilcraft.item.ItemEntangledChalice;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class ModelEntangledChaliceBaked
extends DelegatingDynamicItemAndBlockModel {
    private static final Map<String, Integer> seeds = Maps.newHashMap();
    public static final ResourceLocation chaliceModelName = new ResourceLocation("evilcraft", "block/chalice");
    public static final ResourceLocation gemsModelName = new ResourceLocation("evilcraft", "block/gems");
    public static IBakedModel chaliceModel;
    public static IBakedModel gemsModel;
    private final String id;
    private final FluidStack fluidStack;

    public ModelEntangledChaliceBaked() {
        this.id = "";
        this.fluidStack = null;
    }

    public ModelEntangledChaliceBaked(String id, FluidStack fluidStack, BlockState blockState, Direction facing, Random rand, IModelData modelData) {
        super(blockState, facing, rand, modelData);
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public ModelEntangledChaliceBaked(String id, FluidStack fluidStack, ItemStack itemStack, World world, LivingEntity entity) {
        super(itemStack, world, entity);
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public static int getColorSeed(String id) {
        int gemColor;
        if (seeds.containsKey(id)) {
            gemColor = seeds.get(id);
        } else {
            long res = id.hashCode();
            Random rand = new Random(res);
            gemColor = rand.nextInt(0x1000000) | 0xFF000000;
            seeds.put(id, gemColor);
        }
        return gemColor;
    }

    public List<BakedQuad> getGeneralQuads() {
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(chaliceModel.func_200117_a(this.blockState, this.facing, this.rand));
        int color = ModelEntangledChaliceBaked.getColorSeed(this.id);
        for (BakedQuad quad : gemsModel.func_200117_a(this.blockState, this.facing, this.rand)) {
            int[] data = Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length);
            for (int i = 0; i < data.length / 8; ++i) {
                data[i * 8 + 3] = color;
            }
            quads.add(new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), false));
        }
        if (!this.fluidStack.isEmpty()) {
            quads.addAll(this.getFluidQuads(this.fluidStack, 4000));
        }
        return quads;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileEntangledChalice.class).map(tile -> {
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            builder.withInitial(BlockEntangledChalice.TANK_FLUID, (Object)tile.getTank().getFluid());
            builder.withInitial(BlockEntangledChalice.TANK_ID, (Object)tile.getWorldTankId());
            return builder.build();
        }).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public IBakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        String tankId = (String)ModelHelpers.getSafeProperty((IModelData)modelData, BlockEntangledChalice.TANK_ID, (Object)"");
        FluidStack fluidStack = (FluidStack)ModelHelpers.getSafeProperty((IModelData)modelData, BlockEntangledChalice.TANK_FLUID, (Object)FluidStack.EMPTY);
        if (!BlockEntangledChaliceConfig.staticBlockRendering) {
            fluidStack = FluidStack.EMPTY;
        }
        return new ModelEntangledChaliceBaked(tankId, fluidStack, state, side, rand, modelData);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        String id = FluidUtil.getFluidHandler((ItemStack)itemStack).map(h -> ((ItemEntangledChalice.FluidHandler)((Object)h)).getTankID()).orElse("");
        return new ModelEntangledChaliceBaked(id, FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY), itemStack, world, entity);
    }

    public TextureAtlasSprite func_177554_e() {
        return chaliceModel.func_177554_e();
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity) {
        float height = Math.min(0.95f, (float)fluidStack.getAmount() / (float)capacity) * 0.1875f + 0.8125f;
        ArrayList quads = Lists.newArrayList();
        TextureAtlasSprite texture = RenderHelpers.getFluidIcon((FluidStack)fluidStack, (Direction)Direction.UP);
        int color = RenderHelpers.getFluidBakedQuadColor((FluidStack)fluidStack);
        ModelEntangledChaliceBaked.addBakedQuadRotated((List)quads, (float)0.1875f, (float)0.8125f, (float)0.1875f, (float)0.8125f, (float)height, (TextureAtlasSprite)texture, (Direction)Direction.UP, (int)ROTATION_FIX[Direction.UP.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
        return quads;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelEntangledChaliceBaked)) {
            return false;
        }
        ModelEntangledChaliceBaked other = (ModelEntangledChaliceBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        FluidStack this$fluidStack = this.getFluidStack();
        FluidStack other$fluidStack = other.getFluidStack();
        return !(this$fluidStack == null ? other$fluidStack != null : !this$fluidStack.equals(other$fluidStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelEntangledChaliceBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        FluidStack $fluidStack = this.getFluidStack();
        result = result * 59 + ($fluidStack == null ? 0 : $fluidStack.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public String toString() {
        return "ModelEntangledChaliceBaked(id=" + this.getId() + ", fluidStack=" + this.getFluidStack() + ")";
    }
}

