/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.cyclops.evilcraft.client.render.tileentity.RendererTileEntityEndPortalBase;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;

public class RenderTileEntityBoxOfEternalClosure
extends RendererTileEntityEndPortalBase<TileBoxOfEternalClosure> {
    private static final ResourceLocation beamTexture = new ResourceLocation("evilcraft", "textures/entity/beam.png");
    private static final RenderType renderTypeBeam = RenderType.func_228646_f_((ResourceLocation)beamTexture);

    public RenderTileEntityBoxOfEternalClosure(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileBoxOfEternalClosure tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)tile.func_145831_w().func_180495_p(tile.func_174877_v()), (Property)BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        matrixStackIn.func_227860_a_();
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = -90;
        }
        if (direction == Direction.NORTH) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = 180;
        }
        if (direction == Direction.EAST) {
            rotation = 0;
        }
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        BlockState blockState = (BlockState)tile.func_195044_w().func_206870_a((Property)BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(Atlases.func_228782_g_()), blockState, ModelBoxOfEternalClosureBaked.boxModel, 1.0f, 1.0f, 1.0f, combinedLightIn, OverlayTexture.field_229196_a_);
        float angle = tile.getPreviousLidAngle() + (tile.getLidAngle() - tile.getPreviousLidAngle()) * partialTicks;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.75, 0.375, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-angle));
        matrixStackIn.func_227861_a_(-0.75, -0.375, 0.0);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(Atlases.func_228782_g_()), blockState, ModelBoxOfEternalClosureBaked.boxLidModel, 1.0f, 1.0f, 1.0f, combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        if (angle > 0.0f) {
            super.func_225616_a_(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        matrixStackIn.func_227865_b_();
        EntityVengeanceSpirit target = tile.getTargetSpirit();
        if (target != null) {
            float f = RenderTileEntityBoxOfEternalClosure.func_229051_a_(tile, partialTicks);
            BlockPos blockpos = tile.func_174877_v();
            float f3 = (float)target.func_226277_ct_() + 0.5f;
            float f4 = (float)target.func_226278_cu_() + 0.5f - target.func_70047_e() / 2.0f;
            float f5 = (float)target.func_226281_cx_() + 0.5f;
            float f6 = (float)((double)f3 - (double)blockpos.func_177958_n());
            float f7 = (float)((double)f4 - (double)blockpos.func_177956_o());
            float f8 = (float)((double)f5 - (double)blockpos.func_177952_p());
            matrixStackIn.func_227861_a_((double)f6, (double)f7, (double)f8);
            IRenderTypeBuffer bufferOverride = type -> bufferIn.getBuffer(renderTypeBeam);
            EnderDragonRenderer.func_229059_a_((float)(-f6), (float)(-f7 + f), (float)(-f8), (float)partialTicks, (int)tile.innerRotation, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferOverride, (int)combinedLightIn);
        }
    }

    @Override
    public boolean shouldRenderFace(Direction direction) {
        return direction == Direction.UP;
    }

    public static float func_229051_a_(TileBoxOfEternalClosure p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = MathHelper.func_76126_a((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    protected void renderCube(TileBoxOfEternalClosure tile, float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, IVertexBuilder vb) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.renderFace(tile, p_228883_4_, vb, 0.3125f, 0.6875f, p_228883_2_ - 0.5f, p_228883_2_ - 0.5f, 1.0f, 1.0f, 0.0f, 0.0f, f, f1, f2, Direction.UP);
    }
}

