/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.client.render.model.ModelDarkTankBaked;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class RenderTileEntityDarkTank
extends TileEntityRenderer<TileDarkTank> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.865f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.135f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.865f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.865f, 0.865f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.135f, 0.865f, 0.865f}}, new float[][]{{0.865f, 0.01f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.01f, 0.865f}}};

    public RenderTileEntityDarkTank(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileDarkTank tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluid = tile.getTank().getFluid();
        RenderHelpers.renderFluidContext((FluidStack)fluid, (MatrixStack)matrixStackIn, () -> {
            float height = (float)(tile.getFillRatio() * (double)0.99f);
            int brightness = Math.max(combinedLightIn, fluid.getFluid().getAttributes().getLuminosity(fluid));
            RenderTileEntityDarkTank.renderFluidSides(height, tile.getTank().getFluid(), tile.isEnabled(), brightness, matrixStackIn, bufferIn);
        });
    }

    public static void renderFluidSides(float height, FluidStack fluid, boolean flowing, int brightness, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        Triple colorParts = RenderHelpers.getFluidVertexBufferColor((FluidStack)fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        for (Direction side : DirectionHelpers.DIRECTIONS) {
            TextureAtlasSprite icon = ModelDarkTankBaked.getFluidIcon(fluid, flowing, side);
            IVertexBuilder vb = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
            float[][] c = coordinates[side.ordinal()];
            float minV = icon.func_94206_g();
            float maxV = (icon.func_94210_h() - icon.func_94206_g()) * height + icon.func_94206_g();
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            if (side == Direction.WEST || side == Direction.SOUTH) {
                float tmp = minV;
                minV = maxV;
                maxV = tmp;
            } else if (side == Direction.UP || side == Direction.DOWN) {
                maxV = icon.func_94210_h();
            }
            vb.func_227888_a_(matrix, c[0][0], RenderTileEntityDarkTank.getHeight(side, c[0][1], height), c[0][2]).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, c[1][0], RenderTileEntityDarkTank.getHeight(side, c[1][1], height), c[1][2]).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, c[2][0], RenderTileEntityDarkTank.getHeight(side, c[2][1], height), c[2][2]).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, c[3][0], RenderTileEntityDarkTank.getHeight(side, c[3][1], height), c[3][2]).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225587_b_(l2, i3).func_181675_d();
        }
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.865f) {
            return replaceHeight;
        }
        return height;
    }
}

