/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.tileentity.TileDisplayStand;

public class RenderTileEntityDisplayStand
extends TileEntityRenderer<TileDisplayStand> {
    private static final Map<Direction, Vector3f> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Direction.SOUTH, (Object)new Vector3f(90.0f, 0.0f, 0.0f)).put((Object)Direction.WEST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.EAST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.UP, (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Direction.DOWN, (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();

    public RenderTileEntityDisplayStand(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileDisplayStand tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getInventory().func_70301_a(0).func_190926_b()) {
            BlockState blockState = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            this.renderItem(matrixStackIn, bufferIn, tile.getInventory().func_70301_a(0), (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH), (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.AXIS_X, (Comparable)Boolean.valueOf(true)), tile.getDirection() == Direction.AxisDirection.POSITIVE);
        }
    }

    private void renderItem(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, ItemStack itemStack, Direction facing, boolean axisX, boolean positiveDirection) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (itemStack.func_77973_b() instanceof BlockItem) {
            matrixStack.func_227862_a_(0.6f, 0.6f, 0.6f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        } else if (itemStack.func_77973_b() instanceof IBroom) {
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
        } else if (!(itemStack.func_77973_b() instanceof IBroom)) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 0.25, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        }
        Vector3f vec = ROTATIONS.get(facing);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(vec.func_195899_a()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(vec.func_195900_b()));
        if (!axisX) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            if (!positiveDirection) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
        } else if (positiveDirection) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
        matrixStack.func_227865_b_();
    }
}

