/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class RenderTileEntityEntangledChalice
extends TileEntityRenderer<TileEntangledChalice> {
    public RenderTileEntityEntangledChalice(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntangledChalice tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlayIn) {
        if (tile != null && !tile.getTank().getFluid().isEmpty() && tile.getTank().getFluid().getFluid() != null) {
            try {
                FluidStack fluid = tile.getTank().getFluid();
                RenderHelpers.renderFluidContext((FluidStack)tile.getTank().getFluid(), (MatrixStack)matrixStack, () -> {
                    float height = Math.min(0.95f, (float)fluid.getAmount() / (float)tile.getTank().getCapacity()) * 0.1875f + 0.8125f;
                    int brightness = Math.max(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                    Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v()));
                    IVertexBuilder vb = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
                    Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                    vb.func_227888_a_(matrix, 0.1875f, height, 0.1875f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
                    vb.func_227888_a_(matrix, 0.1875f, height, 0.8125f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                    vb.func_227888_a_(matrix, 0.8125f, height, 0.8125f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                    vb.func_227888_a_(matrix, 0.8125f, height, 0.1875f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
                });
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

