/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import org.cyclops.evilcraft.client.render.tileentity.RenderTileEntityBeacon;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.TileEnvironmentalAccumulator;

public class RenderTileEntityEnvironmentalAccumulator
extends RenderTileEntityBeacon<TileEnvironmentalAccumulator> {
    private static final int ITEM_SPIN_SPEED = 3;

    public RenderTileEntityEnvironmentalAccumulator(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @Override
    public void renderBeacon(TileEnvironmentalAccumulator tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getMovingItemY() != -1.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-0.5, (double)(-0.5f + tile.getMovingItemY()), -0.5);
            this.renderProcessingItem(matrixStack, bufferIn, tile.getRecipe(), tile.getDegradationWorld(), partialTicks);
            matrixStack.func_227865_b_();
        }
        super.renderBeacon(tile, partialTicks, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected boolean isInnerBeam(TileEnvironmentalAccumulator tile) {
        return tile.getMovingItemY() >= 0.0f;
    }

    private void renderProcessingItem(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, RecipeEnvironmentalAccumulator recipe, World world, float partialTickTime) {
        if (recipe == null) {
            return;
        }
        ItemStack stack = recipe.getInputIngredient().func_193365_a()[0];
        if (stack.func_190926_b()) {
            return;
        }
        double totalTickTime = (float)world.func_82737_E() + partialTickTime;
        float angle = (float)(3.0 * (totalTickTime % 360.0));
        if (stack.func_77973_b() instanceof BlockItem) {
            matrixStackIn.func_227861_a_(1.0, (double)0.675f, 1.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        } else {
            matrixStackIn.func_227861_a_(1.0, 1.0, 1.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        }
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
    }
}

