/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.tileentity.TilePurifier;
import org.cyclops.evilcraft.tileentity.tickaction.purifier.DisenchantPurifyAction;

public class RenderTileEntityPurifier
extends TileEntityRenderer<TilePurifier> {
    public static final RenderMaterial TEXTURE_BLOOK = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("evilcraft", "entity/blook"));
    private final BookModel enchantmentBook = new BookModel();

    public RenderTileEntityPurifier(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TilePurifier tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack additionalItem = tile.getAdditionalItem();
        if (!additionalItem.func_190926_b()) {
            if (additionalItem.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK.get() || additionalItem.func_77973_b() == Items.field_151134_bR) {
                this.renderBook(tile, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, additionalItem, partialTicks);
            } else {
                this.renderAdditionalItem(tile, matrixStackIn, bufferIn, additionalItem, partialTicks);
            }
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        if (!tile.getPurifyItem().func_190926_b()) {
            this.renderItem(matrixStackIn, bufferIn, tile.getPurifyItem(), tile.getRandomRotation());
        }
        matrixStackIn.func_227865_b_();
        FluidStack fluid = tile.getTank().getFluid();
        RenderHelpers.renderFluidContext((FluidStack)fluid, (MatrixStack)matrixStackIn, () -> {
            float height = (float)((double)fluid.getAmount() * 0.7 / (double)tile.getTank().getCapacity() + 0.23 + 0.01);
            int brightness = Math.max(combinedLightIn, fluid.getFluid().getAttributes().getLuminosity(fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
            Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v()));
            IVertexBuilder vb = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
            Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            vb.func_227888_a_(matrix, 0.0625f, height, 0.0625f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, 0.0625f, height, 0.9375f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, 0.9375f, height, 0.9375f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
            vb.func_227888_a_(matrix, 0.9375f, height, 0.0625f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
        });
    }

    private void renderItem(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ItemStack itemStack, float rotation) {
        matrixStackIn.func_227860_a_();
        if (itemStack.func_77973_b() instanceof BlockItem) {
            matrixStackIn.func_227861_a_(1.0, (double)1.2f, 1.0);
            matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
        } else {
            matrixStackIn.func_227861_a_(1.0, (double)1.2f, 1.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(25.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(25.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderAdditionalItem(TilePurifier tile, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.func_227860_a_();
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.func_227861_a_(0.5, 0.75, 0.5);
        matrixStackIn.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), 0.0);
        if (itemStack.func_77973_b() instanceof BlockItem) {
            matrixStackIn.func_227861_a_(1.0, (double)0.675f, 1.0);
        }
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.func_227861_a_(0.0, 0.5, 0.0);
        if (!(itemStack.func_77973_b() instanceof BlockItem)) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(25.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderBook(TilePurifier tile, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.75, 0.5);
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), 0.0);
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(80.0f));
        float f3 = MathHelper.func_219799_g((float)partialTickTime, (float)tile.field_195524_g, (float)tile.field_195523_f);
        float f4 = MathHelper.func_226164_h_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = MathHelper.func_226164_h_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = MathHelper.func_219799_g((float)partialTickTime, (float)tile.field_195528_k, (float)tile.field_195527_j);
        this.enchantmentBook.func_228247_a_(rotation, MathHelper.func_76131_a((float)f4, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)f5, (float)0.0f, (float)1.0f), f6);
        RenderMaterial material = itemStack.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK.get() ? TEXTURE_BLOOK : EnchantmentTableTileEntityRenderer.field_147540_b;
        IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, RenderType::func_228634_a_);
        this.enchantmentBook.func_228249_b_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

