/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.cyclops.evilcraft.tileentity.TileSpiritPortal;

public class RenderTileEntitySpiritPortal
extends TileEntityRenderer<TileSpiritPortal> {
    private static final ResourceLocation PORTALBASE = new ResourceLocation("evilcraft", "textures/model/portal_bases.png");

    public RenderTileEntitySpiritPortal(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileSpiritPortal tileentity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float progress = tileentity.getProgress();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        this.renderPortalBase(matrixStackIn, bufferIn, progress);
        Random random = new Random();
        long seed = tileentity.func_174877_v().func_218275_a();
        random.setSeed(seed);
        this.renderStar(matrixStackIn, bufferIn, seed, progress, Tessellator.func_178181_a(), partialTicks, random);
        matrixStackIn.func_227865_b_();
    }

    private void renderStar(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float rotation, float progress, Tessellator tessellator, float partialTicks, Random random) {
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotation * -0.2f % 360.0f / 2.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * -0.2f % 360.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotation * -0.2f % 360.0f / 2.0f));
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 7.0f;
        float MAX_OPACITY = 40.0f;
        RenderHelper.func_74518_a();
        float f2 = 0.0f;
        if (progress > 0.8f) {
            f2 = (progress - 0.8f) / 0.2f;
        }
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + progress * 90.0f));
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            IVertexBuilder vb = bufferIn.getBuffer(RenderType.func_228657_l_());
            Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            vb.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(171, 97, 210, (int)(MAX_OPACITY * (1.0f - f2))).func_181675_d();
            vb.func_227888_a_(matrix, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(175, 100, 215, 0).func_181675_d();
            vb.func_227888_a_(matrix, 0.866f * f4, f3, -0.5f * f4).func_225586_a_(175, 100, 215, 0).func_181675_d();
            vb.func_227888_a_(matrix, 0.0f, f3, 1.0f * f4).func_225586_a_(175, 100, 215, 0).func_181675_d();
            vb.func_227888_a_(matrix, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(175, 100, 215, 0).func_181675_d();
            ++i;
        }
    }

    private void renderPortalBase(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float progress) {
        matrixStackIn.func_227860_a_();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        matrixStackIn.func_227863_a_(renderManager.func_229098_b_());
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        this.renderIconForProgress(matrixStackIn, bufferIn, (int)(progress * 100.0f) % 4, progress);
        matrixStackIn.func_227865_b_();
    }

    private void renderIconForProgress(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int index, float progress) {
        if (progress > 0.8f) {
            progress -= (progress - 0.8f) * 4.0f;
        }
        float u1 = 0.0625f * (float)index;
        float u2 = 0.0625f * (float)(index + 1);
        float v1 = 0.0f;
        float v2 = 0.0625f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.5f * progress, 0.5f * progress, 0.5f * progress);
        matrixStackIn.func_227861_a_(-0.5, -0.5, 0.0);
        int j = 150;
        int k = 150;
        IVertexBuilder vb = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)PORTALBASE));
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        vb.func_227888_a_(matrix, 0.0f, 1.0f, 0.0f).func_227885_a_(0.72f, 0.5f, 0.23f, 0.9f).func_225583_a_(u1, v2).func_225587_b_(j, k).func_181675_d();
        vb.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_227885_a_(0.72f, 0.5f, 0.83f, 0.9f).func_225583_a_(u1, v1).func_225587_b_(j, k).func_181675_d();
        vb.func_227888_a_(matrix, 1.0f, 0.0f, 0.0f).func_227885_a_(0.72f, 0.5f, 0.83f, 0.9f).func_225583_a_(u2, v1).func_225587_b_(j, k).func_181675_d();
        vb.func_227888_a_(matrix, 1.0f, 1.0f, 0.0f).func_227885_a_(0.72f, 0.5f, 0.83f, 0.9f).func_225583_a_(u2, v2).func_225587_b_(j, k).func_181675_d();
        matrixStackIn.func_227865_b_();
    }
}

