/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.algorithm;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class RegionIterator
implements Iterator<BlockPos> {
    private BlockPos center;
    private int offset;
    private boolean shuffle;
    private int loopBlockTick;
    private int maxTick;
    private ArrayList<Integer> shuffledTicks;

    public RegionIterator(BlockPos center, int offset, boolean shuffle) {
        this.center = center;
        this.offset = offset;
        this.shuffle = shuffle;
        this.maxTick = (int)Math.pow(this.getArea(), 3.0);
        this.shuffledTicks = Lists.newArrayList((Iterable)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.maxTick)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        if (this.shuffle) {
            Random random = new Random();
            random.setSeed(this.getShuffleSeed());
            Collections.shuffle(this.shuffledTicks, random);
        }
    }

    private long getShuffleSeed() {
        return this.center.func_218275_a();
    }

    public RegionIterator(BlockPos center, int offset) {
        this(center, offset, false);
    }

    private int getArea() {
        return 2 * this.offset + 1;
    }

    private BlockPos addTickOffset(BlockPos center) {
        int tick = this.shuffledTicks.get(this.loopBlockTick);
        int[] c = new int[3];
        for (int i = 0; i < 3; ++i) {
            int mod = (int)Math.pow(this.getArea(), i + 1);
            int prevMod = (int)Math.pow(this.getArea(), i);
            c[i] = -this.offset + (tick % mod - tick % prevMod) / prevMod;
        }
        return center.func_177982_a(c[0], c[1], c[2]);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public BlockPos next() {
        this.loopBlockTick = (this.loopBlockTick + 1) % this.maxTick;
        BlockPos next = new BlockPos(this.center.func_177958_n(), this.center.func_177956_o(), this.center.func_177952_p());
        return this.addTickOffset(next);
    }

    @Override
    public void remove() {
    }
}

