/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.evilcraft.core.inventory.container.ContainerInventoryTickingTank;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;

public abstract class ContainerScreenContainerTankInventory<C extends ContainerInventoryTickingTank<T>, T extends TickingTankInventoryTileEntity<T>>
extends ContainerScreenExtended<C> {
    private boolean showTank = false;
    private int tankWidth;
    private int tankHeight;
    private int tankX;
    private int tankY;
    private int tankTargetX;
    private int tankTargetY;
    private boolean showProgress = false;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progressTargetX;
    private int progressTargetY;

    public ContainerScreenContainerTankInventory(C container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    protected void setTank(int tankWidth, int tankHeight, int tankX, int tankY, int tankTargetX, int tankTargetY) {
        this.showTank = true;
        this.tankWidth = tankWidth;
        this.tankHeight = tankHeight;
        this.tankX = tankX;
        this.tankY = tankY;
        this.tankTargetX = tankTargetX + this.offsetX;
        this.tankTargetY = tankTargetY + this.offsetY;
    }

    protected void setProgress(int progressWidth, int progressHeight, int progressX, int progressY, int progressTargetX, int progressTargetY) {
        this.showProgress = true;
        this.progressWidth = progressWidth;
        this.progressHeight = progressHeight;
        this.progressX = progressX;
        this.progressY = progressY;
        this.progressTargetX = progressTargetX + this.offsetX;
        this.progressTargetY = progressTargetY + this.offsetY;
    }

    protected boolean isShowProgress() {
        return this.showProgress;
    }

    protected int getProgressXScaled(int width) {
        return width;
    }

    protected int getProgressYScaled(int height) {
        return height;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int x, int y) {
        super.func_230450_a_(matrixStack, f, x, y);
        if (this.isShowProgress()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + this.progressTargetX, this.field_147009_r + this.progressTargetY, this.progressX, this.progressY, this.getProgressXScaled(this.progressWidth), this.getProgressYScaled(this.progressHeight));
        }
    }

    protected abstract ITextComponent getName();

    protected void drawForgegroundString(MatrixStack matrixStack) {
        this.field_230712_o_.func_243248_b(matrixStack, this.getName(), (float)(8 + this.offsetX), (float)(4 + this.offsetY), 0x404040);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawForgegroundString(matrixStack);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidStack();
        if (this.shouldRenderTank(fluidStack) && ((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidCapacity() > 0) {
            int tankSize = Math.min(((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidCapacity(), Math.min(((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidCapacity(), fluidStack.getAmount()) * this.tankHeight / ((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidCapacity());
            this.drawTank(matrixStack, this.tankTargetX, this.tankTargetY, fluidStack.getFluid(), tankSize);
        }
        this.drawAdditionalForeground(matrixStack, mouseX, mouseY);
        GlStateManager.func_227737_l_();
    }

    protected void drawAdditionalForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public void drawCurrentScreen(MatrixStack matrixStack, int mouseX, int mouseY, float gameTicks) {
        super.drawCurrentScreen(matrixStack, mouseX, mouseY, gameTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    protected boolean shouldRenderTank(FluidStack fluidStack) {
        if (!this.showTank) {
            return false;
        }
        return fluidStack.getAmount() > 0;
    }

    protected void drawTank(MatrixStack matrixStack, int xOffset, int yOffset, Fluid fluid, int level) {
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)stack, (Direction)Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight = 0;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                RenderHelpers.bindTexture((ResourceLocation)org.cyclops.evilcraft.core.helper.RenderHelpers.TEXTURE_MAP);
                ContainerScreenContainerTankInventory.func_238470_a_((MatrixStack)matrixStack, (int)xOffset, (int)(yOffset - textureHeight - verticalOffset), (int)0, (int)this.tankWidth, (int)textureHeight, (TextureAtlasSprite)icon);
                verticalOffset += 16;
            }
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.func_238474_b_(matrixStack, xOffset, yOffset - this.tankHeight, this.tankX, this.tankY, this.tankWidth, this.tankHeight);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidStack();
        if (this.func_195359_a(this.tankTargetX, this.tankTargetY - this.tankHeight, this.tankWidth, this.tankHeight, mouseX, mouseY) && this.shouldRenderTank(fluidStack)) {
            ITextComponent fluidName = fluidStack.getDisplayName();
            this.drawBarTooltipTank(fluidName, fluidStack, fluidStack.getAmount(), ((ContainerInventoryTickingTank)this.func_212873_a_()).getFluidCapacity(), mouseX, mouseY);
        }
    }

    protected void drawBarTooltipTank(ITextComponent name, FluidStack fluidStack, int amount, int capacity, int x, int y) {
        ArrayList lines = Lists.newArrayList();
        lines.add(name);
        lines.add(DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity));
        this.drawTooltip(lines, x, y);
    }
}

