/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomModelBaked
extends DynamicItemAndBlockModel {
    protected static final ItemCameraTransforms PERSPECTIVE_TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new ItemTransformVec3f(new Vector3f(90.0f, 180.0f, 90.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new ItemTransformVec3f(new Vector3f(90.0f, 180.0f, 90.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new ItemTransformVec3f(new Vector3f(10.0f, 190.0f, 100.0f), new Vector3f(0.25f, -0.025f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new ItemTransformVec3f(new Vector3f(10.0f, 190.0f, 100.0f), new Vector3f(0.25f, -0.025f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f))));
    private static final Map<IBroomPart, IBakedModel> broomPartModels = Maps.newHashMap();
    private final List<BakedQuad> quads;
    private final Random rand = new Random();

    public BroomModelBaked() {
        super(true, false);
        this.quads = Collections.emptyList();
    }

    public BroomModelBaked(List<BakedQuad> quads) {
        super(false, true);
        this.quads = Objects.requireNonNull(quads);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.quads;
    }

    public IBakedModel handleBlockState(@Nullable BlockState blockState, @Nullable Direction direction, @Nonnull Random random, @Nonnull IModelData iModelData) {
        throw new UnsupportedOperationException();
    }

    public static void addBroomModel(IBroomPart part, IBakedModel bakedModel) {
        broomPartModels.put(part, bakedModel);
    }

    public boolean func_230044_c_() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        IBroomPart rod = null;
        Collection<IBroomPart> parts = BroomParts.REGISTRY.getBroomParts(itemStack);
        for (IBroomPart part : parts) {
            if (part.getType() != IBroomPart.BroomPartType.ROD || rod != null) continue;
            rod = part;
        }
        AtomicLongMap partTypeOccurences = AtomicLongMap.create();
        for (IBroomPart part : parts) {
            IBakedModel model = broomPartModels.get(part);
            if (model == null) continue;
            List originalQuads = model.func_200117_a(null, null, this.rand);
            int typeIndex = (int)partTypeOccurences.getAndIncrement((Object)part.getType());
            float offset = part.getType().getOffsetter().getOffset(rod.getLength(), part.getLength(), typeIndex);
            int color = part.getModelColor();
            quads.addAll(this.offsetAndColor(originalQuads, offset, color));
        }
        return new BroomModelBaked(quads);
    }

    private Collection<? extends BakedQuad> offsetAndColor(List<BakedQuad> quads, float offset, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                float originalZ = Float.intBitsToFloat(vertexData[i * 8 + 2]);
                vertexData[i * 8 + 2] = Float.floatToIntBits(originalZ += offset);
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), false));
        }
        return offsetQuads;
    }

    public ItemCameraTransforms func_177552_f() {
        return PERSPECTIVE_TRANSFORMS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomModelBaked)) {
            return false;
        }
        BroomModelBaked other = (BroomModelBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<BakedQuad> this$quads = this.getQuads();
        List<BakedQuad> other$quads = other.getQuads();
        if (this$quads == null ? other$quads != null : !((Object)this$quads).equals(other$quads)) {
            return false;
        }
        Random this$rand = this.getRand();
        Random other$rand = other.getRand();
        return !(this$rand == null ? other$rand != null : !this$rand.equals(other$rand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomModelBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BakedQuad> $quads = this.getQuads();
        result = result * 59 + ($quads == null ? 0 : ((Object)$quads).hashCode());
        Random $rand = this.getRand();
        result = result * 59 + ($rand == null ? 0 : $rand.hashCode());
        return result;
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public Random getRand() {
        return this.rand;
    }

    public String toString() {
        return "BroomModelBaked(quads=" + this.getQuads() + ", rand=" + this.getRand() + ")";
    }
}

