/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartModelBaked
extends DynamicItemAndBlockModel {
    private final Map<IBroomPart, IBakedModel> broomPartModels = Maps.newHashMap();
    private final List<BakedQuad> quads;
    private final Random rand = new Random();

    public BroomPartModelBaked() {
        super(true, false);
        this.quads = Collections.emptyList();
    }

    public BroomPartModelBaked(List<BakedQuad> quads) {
        super(false, true);
        this.quads = Objects.requireNonNull(quads);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.quads;
    }

    public void addBroomPartModel(IBroomPart part, IBakedModel bakedModel) {
        this.broomPartModels.put(part, bakedModel);
    }

    public boolean func_230044_c_() {
        return true;
    }

    public IBakedModel handleBlockState(@Nullable BlockState blockState, @Nullable Direction direction, @Nonnull Random random, @Nonnull IModelData iModelData) {
        throw new UnsupportedOperationException();
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        Object part = BroomParts.REGISTRY.getPartFromItem(itemStack);
        IBakedModel model = this.broomPartModels.get(part);
        if (model != null) {
            quads.addAll(this.color(model.func_200117_a(null, this.getRenderingSide(), this.rand), part.getModelColor()));
        }
        return new BroomPartModelBaked(quads);
    }

    private Collection<? extends BakedQuad> color(List<BakedQuad> quads, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), false));
        }
        return offsetQuads;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomPartModelBaked)) {
            return false;
        }
        BroomPartModelBaked other = (BroomPartModelBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<IBroomPart, IBakedModel> this$broomPartModels = this.getBroomPartModels();
        Map<IBroomPart, IBakedModel> other$broomPartModels = other.getBroomPartModels();
        if (this$broomPartModels == null ? other$broomPartModels != null : !((Object)this$broomPartModels).equals(other$broomPartModels)) {
            return false;
        }
        List<BakedQuad> this$quads = this.getQuads();
        List<BakedQuad> other$quads = other.getQuads();
        if (this$quads == null ? other$quads != null : !((Object)this$quads).equals(other$quads)) {
            return false;
        }
        Random this$rand = this.getRand();
        Random other$rand = other.getRand();
        return !(this$rand == null ? other$rand != null : !this$rand.equals(other$rand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomPartModelBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<IBroomPart, IBakedModel> $broomPartModels = this.getBroomPartModels();
        result = result * 59 + ($broomPartModels == null ? 0 : ((Object)$broomPartModels).hashCode());
        List<BakedQuad> $quads = this.getQuads();
        result = result * 59 + ($quads == null ? 0 : ((Object)$quads).hashCode());
        Random $rand = this.getRand();
        result = result * 59 + ($rand == null ? 0 : $rand.hashCode());
        return result;
    }

    public Map<IBroomPart, IBakedModel> getBroomPartModels() {
        return this.broomPartModels;
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public Random getRand() {
        return this.rand;
    }

    public String toString() {
        return "BroomPartModelBaked(broomPartModels=" + this.getBroomPartModels() + ", quads=" + this.getQuads() + ", rand=" + this.getRand() + ")";
    }
}

