/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.api.degradation.IDegradationEffect;
import org.cyclops.evilcraft.api.degradation.IDegradationRegistry;

public class DegradationExecutor {
    private static final String ROOT_TAG = "degradationExecutor";
    private static final int DEFAULT_TICK_INTERVAL = 1;
    private int tickInterval = 1;
    private int currentTick = 0;
    private IDegradable degradable;

    public DegradationExecutor(IDegradable degradable) {
        this.degradable = degradable;
    }

    public boolean runRandomEffect(boolean isRemote) {
        ++this.currentTick;
        if (this.currentTick >= this.tickInterval) {
            this.currentTick = 0;
            IDegradationEffect effect = ((IDegradationRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IDegradationRegistry.class)).getRandomDegradationEffect();
            if (effect.canRun(this.degradable)) {
                if (isRemote) {
                    effect.runClientSide(this.degradable);
                } else {
                    effect.runServerSide(this.degradable);
                }
                return true;
            }
        }
        return false;
    }

    public void read(CompoundNBT compound) {
        this.tickInterval = compound.func_74775_l(ROOT_TAG).func_74762_e("tickInterval");
        this.currentTick = compound.func_74775_l(ROOT_TAG).func_74762_e("currentTick");
    }

    public void write(CompoundNBT compound) {
        CompoundNBT content = new CompoundNBT();
        content.func_74768_a("tickInterval", this.tickInterval);
        content.func_74768_a("currentTick", this.currentTick);
        compound.func_218657_a(ROOT_TAG, (INBT)content);
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }
}

