/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class TerraformDegradation
extends StochasticDegradationEffect {
    private static Map<Block, Map<BlockState, Integer>> TERRAFORMATIONS = Maps.newHashMap();
    private static final double CHANCE = 0.1;
    private static Random random = new Random();

    private static void generateReplacements() {
        TerraformDegradation.putReplacement(null, Blocks.field_150347_e.func_176223_P(), 30);
        TerraformDegradation.putReplacement(Blocks.field_150348_b, Blocks.field_150347_e.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150347_e, Blocks.field_150346_d.func_176223_P(), 10);
        TerraformDegradation.putReplacement(Blocks.field_150347_e, Blocks.field_150353_l.func_176223_P(), 30);
        TerraformDegradation.putReplacement(Blocks.field_150402_ci, Blocks.field_150484_ah.func_176223_P(), 10000);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150424_aL.func_176223_P(), 30);
        TerraformDegradation.putReplacement(Blocks.field_150349_c, Blocks.field_150424_aL.func_176223_P(), 20);
        TerraformDegradation.putReplacement(Blocks.field_150391_bh, Blocks.field_150424_aL.func_176223_P(), 5);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150349_c, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150391_bh, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150435_aG.func_176223_P(), 20);
        TerraformDegradation.putReplacement(Blocks.field_150349_c, Blocks.field_150354_m.func_176223_P(), 20);
        TerraformDegradation.putReplacement(Blocks.field_150391_bh, Blocks.field_150354_m.func_176223_P(), 20);
        TerraformDegradation.putReplacement(Blocks.field_150424_aL, RegistryEntries.BLOCK_INFESTED_NETHER_NETHERRACK.func_176223_P(), 50);
        TerraformDegradation.putReplacement(Blocks.field_150354_m, null);
        TerraformDegradation.putReplacement(Blocks.field_150355_j, null);
    }

    private static final void putReplacement(Block key, BlockState value) {
        TerraformDegradation.putReplacement(key, value, 0);
    }

    private static final void putReplacement(Block key, BlockState value, int chance) {
        Map<BlockState, Integer> mapValue = TERRAFORMATIONS.get(key);
        if (mapValue == null) {
            mapValue = new HashMap<BlockState, Integer>();
            TERRAFORMATIONS.put(key, mapValue);
        }
        mapValue.put(value, chance);
    }

    public TerraformDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    protected BlockState getReplacement(Block block) {
        Object[] keys;
        BlockState holder;
        Integer chance;
        Map<BlockState, Integer> mapValue;
        if (TERRAFORMATIONS.isEmpty()) {
            TerraformDegradation.generateReplacements();
        }
        if ((mapValue = TERRAFORMATIONS.get(block)) == null) {
            mapValue = TERRAFORMATIONS.get(null);
        }
        if (mapValue != null && ((chance = mapValue.get(holder = (BlockState)(keys = mapValue.keySet().toArray())[random.nextInt(keys.length)])) == null || chance == 0 || random.nextInt(chance) == 0)) {
            return holder;
        }
        return null;
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        BlockPos blockPos;
        World world = degradable.getDegradationWorld();
        Block block = world.func_180495_p(blockPos = LocationHelpers.getRandomPointInSphere((BlockPos)degradable.getLocation(), (int)degradable.getRadius())).func_177230_c();
        BlockState replace = this.getReplacement(block);
        if (replace != null && !degradable.getLocation().equals((Object)blockPos) && world.func_175625_s(blockPos) == null) {
            if (replace.func_177230_c() == null) {
                world.func_217377_a(blockPos, false);
            } else if (replace.func_185887_b((IBlockReader)world, blockPos) > 0.0f) {
                world.func_180501_a(blockPos, replace, 3);
            }
        }
    }
}

