/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;
    public static final String NBT_KEY_ENABLED = "enabled";
    private static ItemStack bloodBucket = null;

    public static boolean isActivated(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n(NBT_KEY_ENABLED);
    }

    public static void toggleActivation(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            itemStack.func_77982_d(tag);
        }
        tag.func_74757_a(NBT_KEY_ENABLED, !ItemHelpers.isActivated(itemStack));
    }

    public static int getNBTInt(ItemStack itemStack, String tag) {
        if (itemStack.func_190926_b() || itemStack.func_77978_p() == null) {
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e(tag);
    }

    public static void setNBTInt(ItemStack itemStack, int integer, String tag) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a(tag, integer);
    }

    public static void updateAutoFill(IFluidHandlerItem toDrain, World world, Entity entity, boolean fillBuckets) {
        FluidStack tickFluid;
        if (entity instanceof PlayerEntity && !world.func_201670_d() && !(tickFluid = toDrain.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Hand hand : Hand.values()) {
                ItemStack held = player.func_184586_b(hand);
                if (held.func_190926_b() || !fillBuckets && held.func_77973_b() == Items.field_151133_ar) continue;
                ItemStack toFill = held.func_77979_a(1);
                ItemStack filled = ItemHelpers.tryFillContainerForPlayer(toDrain, toFill, tickFluid, player);
                if (!filled.func_190926_b()) {
                    if (player.func_184586_b(hand).func_190926_b()) {
                        player.func_184611_a(hand, filled);
                        continue;
                    }
                    player.func_191521_c(filled);
                    continue;
                }
                held.func_190917_f(1);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IFluidHandlerItem toDrain, ItemStack toFill, FluidStack tickFluid, PlayerEntity player) {
        int maxFill = MB_FILL_PERTICK;
        if (toFill.func_77973_b() == Items.field_151133_ar) {
            maxFill = 1000;
        }
        if (!toFill.func_190926_b() && toFill != toDrain.getContainer() && FluidUtil.getFluidHandler((ItemStack)toFill) != null && player.func_184605_cv() == 0 && FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), (PlayerEntity)player, (boolean)false).isSuccess()) {
            return FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), (PlayerEntity)player, (boolean)true).getResult();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getBloodBucket() {
        if (bloodBucket == null) {
            bloodBucket = new ItemStack((IItemProvider)RegistryEntries.ITEM_BUCKET_BLOOD);
        }
        return bloodBucket;
    }
}

