/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import org.cyclops.cyclopscore.helper.InventoryHelpers;

public class NBTCraftingGrid
extends CraftingInventory {
    private static final String NBT_TAG_ROOT = "CraftingGridInventory";
    protected PlayerEntity player;
    protected int itemIndex;
    protected Hand hand;

    public NBTCraftingGrid(PlayerEntity player, int itemIndex, Hand hand, Container eventHandler) {
        super(eventHandler, 3, 3);
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((PlayerEntity)player, (int)itemIndex, (Hand)hand);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        InventoryHelpers.validateNBTStorage((IInventory)this, (ItemStack)itemStack, (String)NBT_TAG_ROOT);
    }

    public void save() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((PlayerEntity)this.player, (int)this.itemIndex, (Hand)this.hand);
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        itemStack.func_77982_d(tag);
    }

    protected void readFromNBT(CompoundNBT data, String tagName) {
        InventoryHelpers.readFromNBT((IInventory)this, (CompoundNBT)data, (String)tagName);
    }

    protected void writeToNBT(CompoundNBT data, String tagName) {
        InventoryHelpers.writeToNBT((IInventory)this, (CompoundNBT)data, (String)tagName);
    }
}

