/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemBlockFluidContainer
extends ItemBlockNBT {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = (IBlockTank)block;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    protected boolean itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandlerTile -> itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandlerItem -> {
            if (fluidHandlerTile instanceof IFluidHandlerMutable) {
                ((IFluidHandlerMutable)fluidHandlerTile).setFluidInTank(0, fluidHandlerItem.getFluidInTank(0));
            }
            if (fluidHandlerTile instanceof IFluidHandlerCapacity) {
                ((IFluidHandlerCapacity)fluidHandlerTile).setTankCapacity(0, fluidHandlerItem.getTankCapacity(0));
            }
        }));
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (this.block.isActivatable()) {
            return new ActionResult(ActionResultType.PASS, (Object)this.block.toggleActivation(player.func_184586_b(hand), world, player));
        }
        return super.func_77659_a(world, player, hand);
    }

    protected void autofill(int itemSlot, IFluidHandlerItem source, World world, Entity entity) {
        ItemHelpers.updateAutoFill(source, world, entity, BlockDarkTankConfig.autoFillBuckets);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.block.isActivatable() && this.block.isActivated(stack, worldIn)) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(fluidHandler -> this.autofill(itemSlot, (IFluidHandlerItem)fluidHandler, worldIn, entityIn));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        if (CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY != null) {
            list.add((ITextComponent)BlockTankHelpers.getInfoTank(itemStack));
        }
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo(list, (boolean)this.block.isActivated(itemStack, world), (String)(this.func_77658_a() + ".info.auto_supply"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FluidHandlerItemCapacity(stack, this.block.getDefaultCapacity());
    }
}

