/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemBloodContainer
extends DamageIndicatedItemFluidContainer {
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    public ItemBloodContainer(Item.Properties builder, int capacity) {
        super(builder, capacity, () -> RegistryEntries.FLUID_BLOOD);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        FluidStack drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        boolean hasBucket = !drained.isEmpty() && drained.getAmount() == 1000;
        boolean hasSpace = fluidStack.isEmpty() || fluidStack.getAmount() + 1000 <= fluidHandler.getCapacity();
        BlockRayTraceResult movingobjectpositionDrain = ItemBloodContainer.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        BlockRayTraceResult movingobjectpositionFill = ItemBloodContainer.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            BlockState blockState;
            if (this.isPickupFluids() && movingobjectpositionFill.func_216346_c() == RayTraceResult.Type.BLOCK && (blockState = world.func_180495_p(blockPos = movingobjectpositionFill.func_216350_a())).func_177230_c() instanceof FlowingFluidBlock && ((FlowingFluidBlock)blockState.func_177230_c()).getFluid() == this.getFluid() && (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                if (hasSpace) {
                    world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
                    fluidHandler.fill(new FluidStack(this.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return MinecraftHelpers.successAction((Object)itemStack);
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.func_216346_c() == RayTraceResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.func_216350_a();
                Direction direction = movingobjectpositionDrain.func_216354_b();
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.func_177971_a(direction.func_176730_m()), true)) {
                    fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    return MinecraftHelpers.successAction((Object)itemStack);
                }
            }
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    private boolean tryPlaceContainedLiquid(World world, BlockPos blockPos, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        BlockState blockState = world.func_180495_p(blockPos);
        Material material = blockState.func_185904_a();
        if (!world.func_175623_d(blockPos) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_175655_b(blockPos, true);
        }
        world.func_180501_a(blockPos, this.getFluid().getAttributes().getBlock((IBlockDisplayReader)world, blockPos, this.getFluid().func_207188_f()), 3);
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, PlayerEntity player, IFluidHandler.FluidAction action) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = FluidStack.EMPTY;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            FluidStack totalFluid;
            ItemStack current = it.next();
            IFluidHandler containerItem = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)current).orElse(null);
            if (current.func_190926_b() || current == itemStack || containerItem == null || (totalFluid = FluidUtil.getFluidContained((ItemStack)current).orElse(FluidStack.EMPTY)).isEmpty() || totalFluid.getFluid() != fluid || (thisDrained = containerItem.drain(amount, action)).isEmpty() || thisDrained.getFluid() != fluid) continue;
            if (drained.isEmpty()) {
                drained = thisDrained;
            } else {
                drained.setAmount(drained.getAmount() + thisDrained.getAmount());
            }
            amount -= drained.getAmount();
        }
        if (!drained.isEmpty() && drained.isEmpty()) {
            drained = FluidStack.EMPTY;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, @Nullable PlayerEntity player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = FluidUtil.getFluidContained((ItemStack)itemStack).map(FluidStack::getAmount).orElse(0);
        return player != null && !this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public FluidStack consume(int amount, ItemStack itemStack, @Nullable PlayerEntity player) {
        FluidStack otherDrained;
        IFluidHandler.FluidAction fluidAction;
        IFluidHandler.FluidAction fluidAction2 = fluidAction = player == null || !player.func_184812_l_() && !player.field_70170_p.field_72995_K ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE;
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(amount, fluidAction);
        if (!drained.isEmpty() && drained.getAmount() == amount) {
            return drained;
        }
        int drainedAmount = drained.getAmount();
        int toDrain = amount - drainedAmount;
        FluidStack fluidStack = otherDrained = player == null ? FluidStack.EMPTY : this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, fluidAction);
        if (otherDrained.isEmpty()) {
            return drained;
        }
        otherDrained.setAmount(otherDrained.getAmount() + drainedAmount);
        return otherDrained;
    }
}

