/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.monster;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class EntityNoMob
extends CreatureEntity {
    public EntityNoMob(EntityType<? extends EntityNoMob> type, World world) {
        super(type, world);
        this.field_70728_aV = 5;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        this.idle();
        super.func_70636_d();
    }

    protected void idle() {
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187741_cz;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.5f - worldIn.func_205052_D(pos);
    }

    public static boolean isValidLightLevel(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean canMonsterSpawnInLight(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNoMob.isValidLightLevel(worldIn, pos, randomIn) && EntityNoMob.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static boolean canMonsterSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityNoMob.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static AttributeModifierMap.MutableAttribute func_234295_eP_() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected boolean func_230282_cS_() {
        return true;
    }

    public boolean func_230292_f_(PlayerEntity p_230292_1_) {
        return true;
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        if (shootable.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d();
            ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemstack;
        }
        return ItemStack.field_190927_a;
    }
}

