/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.item.ItemBloodExtractor;

public class RecipeBloodExtractorCombination
extends SpecialRecipe {
    private final int maxCapacity;

    public RecipeBloodExtractorCombination(ResourceLocation id, int maxCapacity) {
        super(id);
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingInventory grid, World world) {
        return !this.getCraftingResult(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)RegistryEntries.ITEM_BLOOD_EXTRACTOR);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_BLOODEXTRACTOR_COMBINATION;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        int totalCapacity = 0;
        int totalContent = 0;
        int extractors = 0;
        int tanks = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            FluidStack fluidStack;
            ItemStack element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            if (element.func_77973_b() instanceof BlockItem && ((BlockItem)element.func_77973_b()).func_179223_d() instanceof BlockDarkTank) {
                ++tanks;
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.getAmount());
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0));
                continue;
            }
            if (element.func_77973_b() instanceof ItemBloodExtractor) {
                ++extractors;
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.getAmount());
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0));
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (extractors + tanks < 2 || extractors < 1 || totalCapacity > BlockDarkTankConfig.maxTankSize) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItemCapacity fluidHandlerOutput = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output).orElse(null);
        fluidHandlerOutput.setCapacity(totalCapacity);
        fluidHandlerOutput.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, totalContent), IFluidHandler.FluidAction.EXECUTE);
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }
}

