/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;

public class RecipeBloodInfuser
implements IRecipe<IInventoryFluidTier> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final FluidStack inputFluid;
    private final int inputTier;
    private final ItemStack outputItem;
    private final int duration;
    private final float xp;

    public RecipeBloodInfuser(ResourceLocation id, Ingredient inputIngredient, FluidStack inputFluid, int inputTier, ItemStack outputItem, int duration, float xp) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.inputTier = inputTier;
        this.outputItem = outputItem;
        this.xp = xp;
        this.duration = duration;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getInputTier() {
        return this.inputTier;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean matches(IInventoryFluidTier inv, World worldIn) {
        return this.getInputTier() <= inv.getTier() && this.inputIngredient.test(inv.func_70301_a(0)) && this.inputFluid.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid() && this.inputFluid.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount();
    }

    public ItemStack getCraftingResult(IInventoryFluidTier inv) {
        return this.outputItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack func_77571_b() {
        return this.outputItem;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_BLOOD_INFUSER;
    }

    public IRecipeType<?> func_222127_g() {
        return RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
    }
}

