/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class RecipeEnvironmentalAccumulator
implements IRecipe<Inventory> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final WeatherType inputWeather;
    private final ItemStack outputItem;
    private final WeatherType outputWeather;
    private final int duration;
    private final int cooldownTime;
    private final float processingSpeed;

    public RecipeEnvironmentalAccumulator(ResourceLocation id, Ingredient inputIngredient, WeatherType inputWeather, ItemStack outputItem, WeatherType outputWeather, int duration, int cooldownTime, float processingSpeed) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputWeather = inputWeather;
        this.outputItem = outputItem;
        this.outputWeather = outputWeather;
        this.duration = duration;
        this.cooldownTime = cooldownTime;
        this.processingSpeed = processingSpeed;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public WeatherType getInputWeather() {
        return this.inputWeather;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public WeatherType getOutputWeather() {
        return this.outputWeather;
    }

    public int getDuration() {
        if (this.duration < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.duration;
    }

    public int getCooldownTime() {
        if (this.cooldownTime < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return this.cooldownTime;
    }

    public float getProcessingSpeed() {
        if (this.processingSpeed < 0.0f) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.processingSpeed;
    }

    public boolean matches(Inventory inv, World worldIn) {
        return this.inputIngredient.test(inv.func_70301_a(0)) && this.inputWeather.isActive(worldIn);
    }

    public ItemStack getCraftingResult(Inventory inv) {
        ItemStack inputStack = inv.func_70301_a(0);
        ItemStack itemStack = this.func_77571_b().func_77946_l();
        if (!inputStack.func_190926_b() && inputStack.func_77942_o()) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new CompoundNBT());
            }
            for (String key : inputStack.func_77978_p().func_150296_c()) {
                if (itemStack.func_77978_p().func_74764_b(key)) continue;
                itemStack.func_77978_p().func_218657_a(key, inputStack.func_77978_p().func_74781_a(key));
            }
        }
        return itemStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack func_77571_b() {
        return this.outputItem;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_ENVIRONMENTAL_ACCUMULATOR;
    }

    public IRecipeType<?> func_222127_g() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    public static class InventoryDummy
    extends net.minecraft.inventory.Inventory
    implements Inventory {
        public InventoryDummy(ItemStack ... stacksIn) {
            super(stacksIn);
        }

        @Override
        public World getWorld() {
            return null;
        }

        @Override
        public BlockPos getPos() {
            return null;
        }
    }

    public static interface Inventory
    extends IInventory {
        public World getWorld();

        public BlockPos getPos();
    }
}

