/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.RegistryEntries;

public class RecipeFluidContainerCombination
extends SpecialRecipe {
    private final Ingredient fluidContainer;
    private final int maxCapacity;

    public RecipeFluidContainerCombination(ResourceLocation id, Ingredient fluidContainer, int maxCapacity) {
        super(id);
        this.fluidContainer = fluidContainer;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getFluidContainer() {
        return this.fluidContainer;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingInventory grid, World world) {
        return !this.getCraftingResult(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return this.fluidContainer.func_193365_a()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_FLUIDCONTAINER_COMBINATION;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        IFluidHandlerItemCapacity fluidHandlerOutput = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output).orElse(null);
        FluidStack commonFluid = null;
        int totalCapacity = 0;
        int totalContent = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            if (this.fluidContainer.test(element)) {
                IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).orElse(null);
                ++inputItems;
                FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                if (!fluidStack.isEmpty()) {
                    if (commonFluid == null) {
                        commonFluid = fluidStack;
                    } else if (!commonFluid.equals((Object)fluidStack)) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.getAmount());
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)fluidHandler.getCapacity());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.field_190927_a;
        }
        fluidHandlerOutput.setCapacity(totalCapacity);
        if (commonFluid != null) {
            fluidHandlerOutput.fill(new FluidStack(commonFluid, totalContent), IFluidHandler.FluidAction.EXECUTE);
        }
        output = fluidHandlerOutput.getContainer();
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }
}

