/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class RecipeSerializerBloodInfuser
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RecipeBloodInfuser> {
    public RecipeBloodInfuser read(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        FluidStack inputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)json, (String)"fluid", (boolean)false);
        int inputTier = JSONUtils.func_151208_a((JsonObject)json, (String)"tier", (int)0);
        ItemStack outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false);
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        float xp = JSONUtils.func_151221_a((JsonObject)json, (String)"xp", (float)0.0f);
        if (inputIngredient.func_203189_d() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItemStack.func_190926_b()) {
            throw new JsonSyntaxException("An output item is required");
        }
        if (inputTier < 0) {
            throw new JsonSyntaxException("Tiers can not be negative");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        if (xp < 0.0f) {
            throw new JsonSyntaxException("XP can not be negative");
        }
        return new RecipeBloodInfuser(recipeId, inputIngredient, inputFluid, inputTier, outputItemStack, duration, xp);
    }

    @Nullable
    public RecipeBloodInfuser read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient inputIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        FluidStack inputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        int inputTier = buffer.func_150792_a();
        ItemStack outputItemStack = buffer.func_150791_c();
        int duration = buffer.func_150792_a();
        float xp = buffer.readFloat();
        return new RecipeBloodInfuser(recipeId, inputIngredient, inputFluid, inputTier, outputItemStack, duration, xp);
    }

    public void write(PacketBuffer buffer, RecipeBloodInfuser recipe) {
        recipe.getInputIngredient().func_199564_a(buffer);
        recipe.getInputFluid().writeToPacket(buffer);
        buffer.func_150787_b(recipe.getInputTier());
        buffer.func_150788_a(recipe.getOutputItem());
        buffer.func_150787_b(recipe.getDuration());
        buffer.writeFloat(recipe.getXp());
    }
}

