/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public abstract class RecipeSerializerEnvironmentalAccumulatorAbstract<T extends RecipeEnvironmentalAccumulator>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected WeatherType getWeatherType(String type) throws JsonSyntaxException {
        WeatherType weather = WeatherType.valueOf(type);
        if (weather == null) {
            throw new JsonSyntaxException(String.format("Could not found the weather '%s'", type));
        }
        return weather;
    }

    protected abstract T createRecipe(ResourceLocation var1, Ingredient var2, WeatherType var3, ItemStack var4, WeatherType var5, int var6, int var7, float var8);

    public T read(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        WeatherType inputWeather = this.getWeatherType(JSONUtils.func_151200_h((JsonObject)json, (String)"weather"));
        ItemStack outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false);
        WeatherType outputWeather = this.getWeatherType(JSONUtils.func_151200_h((JsonObject)result, (String)"weather"));
        int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)-1);
        int cooldownTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cooldownTime", (int)-1);
        float processingSpeed = JSONUtils.func_151221_a((JsonObject)json, (String)"processingSpeed", (float)-1.0f);
        return this.createRecipe(recipeId, inputIngredient, inputWeather, outputItemStack, outputWeather, duration, cooldownTime, processingSpeed);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient inputIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        WeatherType inputWeather = this.getWeatherType(buffer.func_150789_c(20));
        ItemStack outputItemStack = buffer.func_150791_c();
        WeatherType outputWeather = this.getWeatherType(buffer.func_150789_c(20));
        int duration = buffer.func_150792_a();
        int cooldownTime = buffer.func_150792_a();
        float processingSpeed = buffer.readFloat();
        return this.createRecipe(recipeId, inputIngredient, inputWeather, outputItemStack, outputWeather, duration, cooldownTime, processingSpeed);
    }

    public void write(PacketBuffer buffer, RecipeEnvironmentalAccumulator recipe) {
        recipe.getInputIngredient().func_199564_a(buffer);
        buffer.func_180714_a(recipe.getInputWeather().toString().toUpperCase(Locale.ENGLISH));
        buffer.func_150788_a(recipe.getOutputItem());
        buffer.func_180714_a(recipe.getOutputWeather().toString().toUpperCase(Locale.ENGLISH));
        buffer.func_150787_b(recipe.getDuration());
        buffer.func_150787_b(recipe.getCooldownTime());
        buffer.writeFloat(recipe.getProcessingSpeed());
    }
}

