/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity;

import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TankInventoryTileEntity
extends CyclopsTileEntity {
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    protected final int tankSize;

    public TankInventoryTileEntity(TileEntityType<?> type, int inventorySize, int stackSize, int tankSize, @Nullable Fluid acceptedFluid) {
        super(type);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.tank = this.createTank(tankSize);
        this.tankSize = tankSize;
        if (acceptedFluid != null) {
            this.tank.setAcceptedFluid(acceptedFluid);
        }
        this.addItemHandlerCapabilities();
        this.addFluidHandlerCapabilities();
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    protected void addItemHandlerCapabilities() {
        for (Direction side : Direction.values()) {
            this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> this.inventory.getItemHandlerSided(side)));
        }
    }

    protected void addFluidHandlerCapabilities() {
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> this.tank));
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    protected SingleUseTank createTank(int tankSize) {
        return new SingleUseTank(tankSize);
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        return super.func_189515_b(tag);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void onTankChanged() {
        this.func_70296_d();
        this.getInventory().func_70296_d();
    }
}

