/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;

public abstract class TickingTankInventoryTileEntity<T extends TankInventoryTileEntity>
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private List<TickComponent<T, ITickAction<T>>> tickers = Lists.newArrayList();
    private int currentState = -1;
    private int previousState = -1;

    public TickingTankInventoryTileEntity(TileEntityType<?> type, int inventorySize, int stackSize, int tankSize, Fluid acceptedFluid) {
        super(type, inventorySize, stackSize, tankSize, acceptedFluid);
    }

    protected int addTicker(TickComponent<T, ITickAction<T>> ticker) {
        this.tickers.add(ticker);
        return this.tickers.size() - 1;
    }

    public List<TickComponent<T, ITickAction<T>>> getTickers() {
        return this.tickers;
    }

    @Override
    public void read(CompoundNBT data) {
        super.read(data);
        this.currentState = data.func_74762_e("currentState");
        ListNBT tickerList = data.func_150295_c("tickers", 10);
        for (int i = 0; i < this.tickers.size(); ++i) {
            TickComponent<T, ITickAction<T>> ticker = this.tickers.get(i);
            if (tickerList.size() <= i) continue;
            CompoundNBT tag = tickerList.func_150305_b(i);
            ticker.setTick(tag.func_74762_e("tick"));
            ticker.setRequiredTicks(tag.func_74760_g("requiredTicks"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        data = super.func_189515_b(data);
        data.func_74768_a("currentState", this.currentState);
        ListNBT tickerList = new ListNBT();
        for (TickComponent<T, ITickAction<T>> ticker : this.tickers) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("tick", ticker.getTick());
            tag.func_74776_a("requiredTicks", ticker.getRequiredTicks());
            tickerList.add((Object)tag);
        }
        data.func_218657_a("tickers", (INBT)tickerList);
        return data;
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.func_201670_d()) {
            boolean redstone = this.field_145850_b.func_175640_z(this.func_174877_v());
            for (TickComponent<T, ITickAction<T>> ticker : this.getTickers()) {
                if (ticker.isRedstoneDisableable() && redstone) continue;
                ticker.tick(this.getInventory().func_70301_a(ticker.getSlot()), ticker.getSlot());
            }
        }
        if (!this.hasJustWorked()) {
            if (!this.field_145850_b.func_201670_d()) {
                int newState = this.getNewState();
                if (newState != this.currentState) {
                    this.currentState = newState;
                    this.onStateChanged();
                }
            } else if (this.previousState != this.currentState) {
                this.previousState = this.currentState;
                this.onStateChanged();
            }
        }
    }

    protected boolean hasJustWorked() {
        return false;
    }

    public abstract int getNewState();

    public abstract void onStateChanged();

    public int getCurrentState() {
        return this.currentState;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

