/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.evilcraft.core.config.extendedconfig.UpgradableBlockContainerConfig;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradable;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.item.ItemPromise;

public abstract class TileWorking<T extends TileWorking<T, O>, O>
extends TickingTankInventoryTileEntity<T>
implements IUpgradable<T, O> {
    public static final int INVENTORY_SIZE_UPGRADES = 4;
    private int basicInventorySize;
    private Map<Upgrades.Upgrade, Integer> levels = null;
    protected Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> upgradeBehaviour = Maps.newHashMap();
    private boolean hasJustWorked;

    public TileWorking(TileEntityType<?> type, int inventorySize, int stackSize, int tankSize, Fluid acceptedFluid) {
        super(type, inventorySize + 4, stackSize, tankSize, acceptedFluid);
        this.basicInventorySize = inventorySize;
    }

    public int getBasicInventorySize() {
        return this.basicInventorySize;
    }

    public abstract Metadata getTileWorkingMetadata();

    public abstract boolean canWork();

    public boolean isWorking() {
        return this.getWorkTick() > 0;
    }

    public boolean isVisuallyWorking() {
        return this.getCurrentState() == 1 && this.canWork();
    }

    public int getWorkTickScaled(int scale) {
        return (int)Math.ceil((float)(this.getWorkTick() + 1) / this.getRequiredWorkTicks() * (float)scale);
    }

    protected abstract int getWorkTicker();

    protected int getWorkTick() {
        return this.getTickers().get(this.getWorkTicker()).getTick();
    }

    protected float getRequiredWorkTicks() {
        return this.getTickers().get(this.getWorkTicker()).getRequiredTicks();
    }

    public void resetWork() {
        this.resetWork(true);
    }

    public void resetWork(boolean hardReset) {
        if (hardReset) {
            this.getTickers().get(this.getWorkTicker()).setTick(0);
            this.getTickers().get(this.getWorkTicker()).setRequiredTicks(0.0f);
        }
    }

    @Override
    public int getNewState() {
        return this.isWorking() ? 1 : 0;
    }

    @Override
    protected boolean hasJustWorked() {
        return this.hasJustWorked;
    }

    @Override
    public void updateTileEntity() {
        this.hasJustWorked = this.isWorking();
        super.updateTileEntity();
    }

    @Override
    public void onStateChanged() {
        this.func_70296_d();
    }

    protected List<ItemStack> getUpgradeItems() {
        LinkedList itemStacks = Lists.newLinkedList();
        for (int i = this.basicInventorySize; i < this.basicInventorySize + 4; ++i) {
            ItemStack itemStack = this.getInventory().func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    protected void resetUpgradeLevels() {
        this.levels = null;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory<T>(inventorySize, stackSize, this){

            public boolean func_180462_a(int slot, ItemStack itemStack, Direction side) {
                return super.func_180462_a(slot, itemStack, side) && this.func_180462_a(slot, itemStack, side);
            }

            public boolean func_180461_b(int slot, ItemStack itemStack, Direction side) {
                return super.func_180461_b(slot, itemStack, side) && this.func_180461_b(slot, itemStack, side);
            }
        };
    }

    public Map<Upgrades.Upgrade, Integer> getUpgradeLevels() {
        if (this.levels == null) {
            this.levels = Maps.newHashMap();
            for (ItemStack itemStack : this.getUpgradeItems()) {
                Upgrades.Upgrade upgrade = this.getUpgradeType(itemStack);
                int level = this.getUpgradeLevel(itemStack);
                if (this.levels.containsKey(upgrade)) {
                    level += this.levels.get(upgrade).intValue();
                }
                this.levels.put(upgrade, level);
            }
        }
        return this.levels;
    }

    @Override
    public Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> getUpgradeBehaviour() {
        return this.upgradeBehaviour;
    }

    public Upgrades.Upgrade getUpgradeType(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemPromise) {
            Upgrades.Upgrade upgrade = ((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack);
            if (this.getTileWorkingMetadata().getUpgrades().contains(upgrade)) {
                return upgrade;
            }
        }
        return null;
    }

    public int getUpgradeLevel(ItemStack itemStack) {
        return itemStack.func_190916_E();
    }

    public boolean onUpgradeSlotChanged(int slotId, ItemStack oldItemStack, ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)oldItemStack, (ItemStack)itemStack)) {
            this.resetUpgradeLevels();
            this.resetWork();
            if (!this.field_145850_b.func_201670_d()) {
                this.getTank().setCapacity(TileWorking.getTankTierMultiplier(this.getTileWorkingMetadata().getTier((IInventory)this.getInventory())) * this.tankSize);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public static int getTankTierMultiplier(int tier) {
        return 1 << tier * 2;
    }

    public static abstract class Metadata {
        private final int basicInventorySize;

        protected Metadata(int basicInventorySize) {
            this.basicInventorySize = basicInventorySize;
        }

        public int getBasicInventorySize() {
            return this.basicInventorySize;
        }

        public abstract boolean canConsume(ItemStack var1, World var2);

        public boolean canInsertItem(IInventory inventory, int slot, ItemStack itemStack) {
            if (!this.isUpgradeSlot(slot)) {
                return true;
            }
            if (!(itemStack.func_77973_b() instanceof ItemPromise) || !this.getUpgrades().contains(((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack))) {
                return false;
            }
            if (this.isTierUpgrade(itemStack) && this.isTierUpgrade(inventory.func_70301_a(slot))) {
                return true;
            }
            if (this.isTierUpgrade(inventory.func_70301_a(slot))) {
                return this.areUpgradeSlotsValidForTier(inventory, 0);
            }
            if (this.isTierUpgrade(itemStack)) {
                return this.getTier(inventory) == 0 && this.getRequiredTierForSlot(slot) <= ((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack).getTier();
            }
            return this.isUpgradeSlotEnabled(inventory, slot);
        }

        public boolean canExtractItem(IInventory inventory, int slot, ItemStack itemStack, ItemStack replaceItem) {
            if (!this.isUpgradeSlot(slot)) {
                return true;
            }
            if (this.isTierUpgrade(itemStack) && this.isTierUpgrade(replaceItem)) {
                int currentTier;
                int newTier = ((ItemPromise)replaceItem.func_77973_b()).getUpgrade(replaceItem).getTier();
                return newTier >= (currentTier = ((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack).getTier()) || this.areUpgradeSlotsValidForTier(inventory, newTier);
            }
            if (this.isTierUpgrade(itemStack)) {
                return this.areUpgradeSlotsValidForTier(inventory, 0);
            }
            return true;
        }

        protected boolean isUpgradeSlot(int slotId) {
            return slotId >= this.basicInventorySize && slotId < this.basicInventorySize + 4;
        }

        protected boolean isTierUpgrade(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof ItemPromise && ((ItemPromise)itemStack.func_77973_b()).isTierUpgrade(itemStack);
        }

        protected boolean areUpgradeSlotsValidForTier(IInventory inventory, int tier) {
            for (int i = this.basicInventorySize + tier + 1; i < this.basicInventorySize + 4; ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemPromise && ((ItemPromise)itemStack.func_77973_b()).isTierUpgrade(itemStack)) continue;
                return false;
            }
            return true;
        }

        public boolean isUpgradeSlotEnabled(IInventory inventory, int slotId) {
            return this.getRequiredTierForSlot(slotId) <= this.getTier(inventory);
        }

        protected int getRequiredTierForSlot(int slotId) {
            if (!this.isUpgradeSlot(slotId)) {
                return 0;
            }
            return slotId - this.basicInventorySize;
        }

        public int getTier(IInventory inventory) {
            for (int i = this.basicInventorySize; i < this.basicInventorySize + 4; ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (!(itemStack.func_77973_b() instanceof ItemPromise) || !((ItemPromise)itemStack.func_77973_b()).isTierUpgrade(itemStack)) continue;
                return ((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack).getTier();
            }
            return 0;
        }

        public Set<Upgrades.Upgrade> getUpgrades() {
            return UpgradableBlockContainerConfig.getBlockUpgrades(this.getBlock());
        }

        protected abstract Block getBlock();
    }

    public static class Inventory<T extends TileWorking<T, ?>>
    extends SimpleInventory {
        protected final T tile;

        public Inventory(int size, int stackLimit, T tile) {
            super(size, stackLimit);
            this.tile = tile;
        }

        public ItemStack func_70298_a(int slotId, int count) {
            ItemStack itemStack = super.func_70298_a(slotId, count);
            if (((TileWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slotId)) {
                ItemStack oldItemStack = itemStack.func_77946_l();
                oldItemStack.func_190917_f(count);
                ((TileWorking)this.tile).onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
            }
            return itemStack;
        }

        public void func_70299_a(int slotId, ItemStack itemStack) {
            ItemStack oldItemStack = this.func_70301_a(slotId);
            if (!oldItemStack.func_190926_b()) {
                oldItemStack = oldItemStack.func_77946_l();
            }
            super.func_70299_a(slotId, itemStack);
            if (((TileWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slotId)) {
                ((TileWorking)this.tile).onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
            }
        }

        public boolean func_94041_b(int slot, ItemStack itemStack) {
            return ((TileWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slot) && ((TileWorking)this.tile).getTileWorkingMetadata().isUpgradeSlotEnabled((IInventory)((TankInventoryTileEntity)((Object)this.tile)).getInventory(), slot) || super.func_94041_b(slot, itemStack);
        }
    }
}

