/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class EnchantmentBreaking
extends Enchantment {
    public EnchantmentBreaking() {
        super(Enchantment.Rarity.COMMON, EnchantmentType.BREAKABLE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        DamageableItemRepairAction.BAD_ENCHANTS.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakingEvent(LivingAttackEvent event) {
        LivingEntity entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (!event.getEntity().func_130014_f_().func_201670_d() && event.getSource().func_76346_g() instanceof LivingEntity && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (LivingEntity)event.getSource().func_76346_g()).func_184586_b(entity.func_184600_cs())), (Enchantment)this)) > -1) {
            EnchantmentBreaking.amplifyDamage(itemStack, enchantmentListID, new Random());
            entity.func_184611_a(entity.func_184600_cs(), itemStack);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakingEvent(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            int i = EnchantmentHelpers.doesEnchantApply((ItemStack)event.getPlayer().func_184586_b(event.getPlayer().func_184600_cs()), (Enchantment)this);
            ItemStack itemStack = event.getPlayer().func_184586_b(event.getPlayer().func_184600_cs());
            EnchantmentBreaking.amplifyDamage(itemStack, i, new Random());
            event.getPlayer().func_184611_a(event.getPlayer().func_184600_cs(), itemStack);
        }
    }

    public int func_77321_a(int level) {
        return 1 + (level - 1) * 8;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_190936_d() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static void amplifyDamage(ItemStack itemStack, int enchantmentListID, Random random) {
        if (enchantmentListID > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            int newDamage = itemStack.func_77952_i() + 2;
            if (!(random.nextFloat() < 0.6f) && random.nextInt(level + 1) > 0 && newDamage <= itemStack.func_77958_k()) {
                itemStack.func_196085_b(newDamage);
            }
        }
    }
}

