/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;

public class EnchantmentPoisonTip
extends Enchantment {
    private static final int POISON_BASE_DURATION = 2;

    public EnchantmentPoisonTip() {
        super(Enchantment.Rarity.RARE, EnchantmentType.BOW, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void poisonTipEvent(LivingAttackEvent event) {
        LivingEntity entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (!event.getEntity().func_130014_f_().func_201670_d() && event.getSource().func_76346_g() instanceof LivingEntity && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (LivingEntity)event.getSource().func_76346_g()).func_184614_ca()), (Enchantment)this)) > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            EnchantmentPoisonTip.poison((LivingEntity)event.getEntity(), level);
            return;
        }
    }

    public int func_77321_a(int level) {
        return 10 + (level - 1) * 10;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public static void poison(LivingEntity entity, int level) {
        entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 40 * (level + 1), 1));
    }
}

