/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.enchantment.EnchantmentVengeanceConfig;
import org.cyclops.evilcraft.item.ItemVengeanceRing;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class EnchantmentVengeance
extends Enchantment {
    public EnchantmentVengeance() {
        super(Enchantment.Rarity.COMMON, EnchantmentType.BREAKABLE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        DamageableItemRepairAction.BAD_ENCHANTS.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_77321_a(int level) {
        return 1 + (level - 1) * 8;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_190936_d() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        int level;
        PlayerEntity player = event.getPlayer();
        if (player != null && !player.field_70170_p.func_201670_d() && (level = EnchantmentVengeance.getEnchantLevel(heldItem = player.func_184586_b(player.func_184600_cs()))) > 0) {
            EnchantmentVengeance.apply(player.field_70170_p, level, (LivingEntity)player);
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        PlayerEntity player;
        ItemStack heldItem;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof PlayerEntity && !entity.field_70170_p.func_201670_d() && (level = EnchantmentVengeance.getEnchantLevel(heldItem = (player = (PlayerEntity)entity).func_184586_b(player.func_184600_cs()))) > 0) {
            EnchantmentVengeance.apply(player.field_70170_p, level, (LivingEntity)player);
        }
    }

    public static int getEnchantLevel(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return 0;
        }
        return EnchantmentHelper.func_77506_a((Enchantment)RegistryEntries.ENCHANTMENT_VENGEANCE, (ItemStack)itemStack);
    }

    public static void apply(World world, int level, LivingEntity entity) {
        int chance;
        if (level > 0 && (chance = Math.max(1, EnchantmentVengeanceConfig.vengeanceChance / level)) > 0 && world.field_73012_v.nextInt(chance) == 0) {
            int area = EnchantmentVengeanceConfig.areaOfEffect * level;
            ItemVengeanceRing.toggleVengeanceArea(world, (Entity)entity, area, true, true, true);
        }
    }
}

