/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimedConfig;

public class EntityLightningBombPrimed
extends TNTEntity {
    private static final float EXPLOSION_STRENGTH = 1.0f;
    @Nullable
    private LivingEntity placer;

    public EntityLightningBombPrimed(EntityType<? extends EntityLightningBombPrimed> type, World world) {
        super(type, world);
        this.setFuse();
    }

    public EntityLightningBombPrimed(World world, double x, double y, double z, @Nullable LivingEntity placer) {
        this(RegistryEntries.ENTITY_LIGHTNING_BOMB_PRIMED, world);
        this.func_70107_b(x, y, z);
        double d0 = world.field_73012_v.nextDouble() * 6.2831854820251465;
        this.func_213293_j(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.func_184534_a(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.placer = placer;
        this.setFuse();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public LivingEntity func_94083_c() {
        return this.placer;
    }

    protected void setFuse() {
        this.func_184534_a(EntityLightningBombPrimedConfig.fuse);
    }

    public void func_70071_h_() {
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        if (this.func_184536_l() - 1 <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.func_201670_d()) {
                this.explode(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
        } else {
            this.func_184534_a(this.func_184536_l() - 1);
            this.func_71061_d_();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private void explode(World world, double x, double y, double z) {
        if (!world.func_201670_d()) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0f, Explosion.Mode.DESTROY);
            LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            bolt.func_225653_b_(x, y, z);
        } else {
            Random rand = new Random();
            for (int i = 0; i < 32; ++i) {
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)ParticleTypes.field_197614_g, false, x, y + rand.nextDouble() * 2.0, z, rand.nextGaussian(), 0.0, rand.nextGaussian());
            }
        }
    }
}

